package org.maachang.engine.tags;

import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;

/**
 * jsp用Velocityテンプレート表示タグ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class VelocityTag extends BodyTagSupport {
    private static final long serialVersionUID = 3950901775266918208L;
    private static final String MAP_NAME = "*_velocity*_view*_map" ;
    public VelocityTag() {
        super() ;
    }
    public int doAfterBody() throws JspTagException {
        BodyContent bc = getBodyContent();
        String bodyValue = bc.getString();
        if( bodyValue == null || ( bodyValue = bodyValue.trim() ).length() <= 0 ) {
            try {
                bc.getEnclosingWriter().print("");
            } catch (Exception e) {
                throw new JspTagException(e);
            }
        }
        else {
            HttpServletRequest req = (HttpServletRequest) pageContext.getRequest();
            try {
                String result = convertVelocity(req, bodyValue);
                if (result == null || ( result = result.trim() ).length() <= 0) {
                    result = "";
                }
                bc.getEnclosingWriter().print(result);
            } catch (Exception e) {
                throw new JspTagException(e);
            }
        }
        return SKIP_BODY;
    }
    
    public void release() {
    }
    
    private Map getMap( HttpServletRequest req )
        throws Exception {
        Map ret = null ;
        synchronized( req ) {
            ret = ( Map )req.getAttribute( MAP_NAME ) ;
            if( ret == null ) {
                ret = new HashMap<String,Object>() ;
                for (Enumeration e = req.getAttributeNames(); e.hasMoreElements();) {
                    String key = ( String )e.nextElement() ;
                    Object value = req.getAttribute( key ) ;
                    if( value == null ) {
                        value = "" ;
                    }
                    ret.put( key,value ) ;
                }
                req.setAttribute( MAP_NAME,ret ) ;
            }
        }
        return ret ;
    }
    
    private final String convertVelocity( HttpServletRequest req,String body )
        throws Exception {
        Map map = getMap( req ) ;
        StringWriter w = new StringWriter() ;
        Velocity.evaluate( new VelocityContext( map ),w,null,body ) ;
        w.flush() ;
        String ret = w.toString() ;
        w.close() ;
        w = null ;
        return ret ;
    }
}
