package org.maachang.engine.tags;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.maachang.engine.servlet.ActionServlet;
import org.maachang.engine.servlet.GlobalInfo;
import org.maachang.engine.servlet.PageSessionManager;

/**
 * jsp用MaaEngineページセッションタグ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class ToPageSessionTag extends TagSupport {
    private static final long serialVersionUID = -2944046230290553756L;

    public ToPageSessionTag() {
        super();
    }

    public int doStartTag() throws JspException {
        HttpServletRequest req = (HttpServletRequest) pageContext.getRequest();
        try {
            String sessionId = ( String )req.getAttribute(ActionServlet.INNER_PAGE_SESSION) ;
            if( sessionId != null && ( sessionId = sessionId.trim() ).length() == PageSessionManager.RANDOM_SIZE ) {
                if( GlobalInfo.getPageSessionManager() != null ) {
                    if( GlobalInfo.getPageSessionManager().getSession( sessionId ) == null ) {
                        sessionId = null ;
                    }
                }
                else {
                    sessionId = null ;
                }
            }
            else {
                sessionId = null ;
            }
            if( sessionId != null ) {
                pageContext.getOut().print(
                    new StringBuilder().append( "<input type=\"hidden\" name=\"" ).
                    append( ActionServlet.INNER_PAGE_SESSION ).
                    append( "\" value=\"" ).
                    append( sessionId ).append( "\">" ).toString() ) ;
            }
        } catch (Exception e) {
            throw new JspException(e);
        }
        return SKIP_BODY;
    }

    public int doEndTag() {
        return EVAL_PAGE;
    }
}