package org.maachang.engine.tags;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.maachang.engine.servlet.ResultMessage;

/**
 * jsp用MaaEngine正常メッセージ出力用タグ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class OutMessageTag extends TagSupport {
    private static final long serialVersionUID = -2944046230290553756L;

    public OutMessageTag() {
        super();
    }

    public int doStartTag() throws JspException {
        HttpServletRequest req = (HttpServletRequest) pageContext.getRequest();
        try {
            String msg = (String) req.getAttribute(ResultMessage.SUCCESS_MESSAGE);
            if (msg != null) {
                pageContext.getOut().print(
                        "<div id=\"smsgId\" class=\"smsg\" style=\"color:blue;\">" + msg + "</div>");
            }
            else {
                pageContext.getOut().print(
                        "<div id=\"smsgId\" class=\"smsg\" style=\"color:blue;\"></div>");
            }
        } catch (Exception e) {
            throw new JspException(e);
        }
        return SKIP_BODY;
    }

    public int doEndTag() {
        return EVAL_PAGE;
    }
}