package org.maachang.engine.tags;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.maachang.engine.servlet.ResultMessage;

/**
 * jsp用MaaEngineエラーコード出力用タグ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class OutErrorTag extends TagSupport {
    private static final long serialVersionUID = -2944046230290553756L;
    
    public OutErrorTag() {
        super();
    }

    public int doStartTag() throws JspException {
        HttpServletRequest req = (HttpServletRequest) pageContext.getRequest();
        try {
            String err = (String) req.getAttribute(ResultMessage.ERROR_MESSAGE);
            if (err != null) {
                pageContext.getOut().print(
                        "<div id=\"emsgId\" class=\"emsg\" style=\"color:red;\">" + err + "</div>");
            }
            else {
                pageContext.getOut().print(
                        "<div id=\"emsgId\" class=\"emsg\" style=\"color:red;\"></div>");
            }
        } catch (Exception e) {
            throw new JspException(e);
        }
        return SKIP_BODY;
    }

    public int doEndTag() {
        return EVAL_PAGE;
    }
}