package org.maachang.engine.tags;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.maachang.engine.util.StringUtil;

/**
 * jsp用AttributeのList内容表示タグ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class ListTag extends BodyTagSupport {
    private static final long serialVersionUID = -5329129815051789082L;

    private String name = null;

    public ListTag() {
        super() ;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int doAfterBody() throws JspTagException {
        BodyContent bc = getBodyContent();
        String bodyValue = bc.getString();
        if( bodyValue == null || ( bodyValue = bodyValue.trim() ).length() <= 0 ) {
            try {
                bc.getEnclosingWriter().print("");
            } catch (Exception e) {
                throw new JspTagException(e);
            }
        }
        else {
            HttpServletRequest req = (HttpServletRequest) pageContext.getRequest();
            String result = convertData(req, name, bodyValue);
            try {
                if (result == null || ( result = result.trim() ).length() <= 0) {
                    result = "";
                }
                bc.getEnclosingWriter().print(result);
            } catch (Exception e) {
                throw new JspTagException(e);
            }
        }
        return SKIP_BODY;
    }

    public void release() {
    }

    private static final String ST = "$(";

    private static final String ED = ")";

    private static final int BUF = 8192;

    public static final String convertData(HttpServletRequest req, String name,
            String value) {
        if (value == null || (value = value.trim()).length() <= 0) {
            return null;
        } else if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        Object o = req.getAttribute(name);
        if (o == null || (o instanceof List) == false) {
            return null;
        }
        ArrayList<Object> lst = (ArrayList<Object>) o;
        int len = lst.size();
        if (len <= 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder(BUF);
        for (int i = 0; i < len; i++) {
            if (i != 0) {
                buf.append("\r\n");
            }
            o = lst.get(i);
            int p, b;
            for (p = 0, b = 0;;) {
                p = value.indexOf(ST, b);
                if (p == -1) {
                    buf.append(value.substring(b, value.length()));
                    break;
                }
                int x = value.indexOf(ED, p);
                if (x == -1) {
                    buf.append(value.substring(b, value.length()));
                    break;
                }
                if (p != b) {
                    buf.append(value.substring(b, p));
                }
                int y = value.indexOf(ST, p + 1);
                if (y != -1 && x > y) {
                    buf.append(value.substring(p, y));
                    b = y;
                    continue;
                }
                String ky = value.substring(p + ST.length(), x);
                b = x + 1;
                if (ky != null && (ky = ky.trim()).length() > 0) {
                    buf.append(getParamByBeanName(o, ky));
                }
            }
        }
        return buf.toString();
    }

    private static final String getParamByBeanName(Object o, String key) {
        String methodName = getBaseMethodName(key);
        String ret = getMethodByDataString(o, methodName);
        if (ret == null) {
            methodName = getBooleanMethodName(key);
            ret = getMethodByDataString(o, methodName);
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    private static final String getBaseMethodName(String key) {
        return new StringBuilder().append("get").append(
                key.substring(0, 1).toUpperCase()).append(
                key.substring(1, key.length())).toString();
    }

    private static final String getBooleanMethodName(String key) {
        return new StringBuilder().append("is").append(
                key.substring(0, 1).toUpperCase()).append(
                key.substring(1, key.length())).toString();
    }

    private static final String getMethodByDataString(Object o,
            String methodName) {
        Class c = o.getClass();
        try {
            Method md = c.getMethod(methodName);
            Object x = md.invoke(o);
            String ret = null;
            if (x != null) {
                if ((x instanceof String) == false) {
                    ret = x.toString();
                } else {
                    ret = (String) x;
                }
                ret = StringUtil.changeString(ret, "&", "&amp;");
                ret = StringUtil.changeString(ret, "<", "&lt;");
                ret = StringUtil.changeString(ret, ">", "&gt;");
                ret = StringUtil.changeString(ret, "'", "&#039;");
                ret = StringUtil.changeString(ret, "\"", "&#034;");
                ret = StringUtil.changeString(ret, "\n", "<br />");
                return ret;
            }
        } catch (Exception e) {
        }
        return null;
    }
}
