package org.maachang.engine.tags;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * jsp用AttributeのListサイズ取得タグ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class ListSizeTag extends TagSupport {
    private static final long serialVersionUID = 2531000747613725785L;

    private String name = null;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public ListSizeTag() {
        super();
    }

    public int doStartTag() throws JspException {
        HttpServletRequest req = (HttpServletRequest) pageContext.getRequest();
        try {
            Object o = req.getAttribute(name);
            if (o == null || (o instanceof List) == false) {
                pageContext.getOut().print("");
            } else {
                pageContext.getOut().print(((List) o).size());
            }
        } catch (Exception e) {
            throw new JspException(e);
        }
        return SKIP_BODY;
    }

    public int doEndTag() {
        return EVAL_PAGE;
    }
}
