package org.maachang.engine.tags;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * jsp用Attributeタグ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class GetTag extends TagSupport {
    private static final long serialVersionUID = -7470880535101344159L;

    private String name = null;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public GetTag() {
        super();
    }

    public int doStartTag() throws JspException {
        HttpServletRequest req = (HttpServletRequest) pageContext.getRequest();
        try {
            String o = (String) req.getAttribute(name);
            if (o == null || (o = o.trim()).length() <= 0) {
                pageContext.getOut().print("");
            } else {
                pageContext.getOut().print(o);
            }
        } catch (Exception e) {
            throw new JspException(e);
        }
        return SKIP_BODY;
    }

    public int doEndTag() {
        return EVAL_PAGE;
    }
}
