package org.maachang.engine.tags;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.maachang.engine.util.StringUtil;

/**
 * jsp用Attributeタグ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class AttributeTag extends TagSupport {
    private static final long serialVersionUID = -7470880535101344159L;

    private String name = null;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public AttributeTag() {
        super();
    }

    public int doStartTag() throws JspException {
        HttpServletRequest req = (HttpServletRequest) pageContext.getRequest();
        try {
            Object x = req.getAttribute(name) ;
            if( x == null ) {
                pageContext.getOut().print("");
            }
            else if( x instanceof String ) {
                String o = (String) x ;
                if (o == null || (o = o.trim()).length() <= 0) {
                    pageContext.getOut().print("");
                } else {
                    o = StringUtil.changeString(o, "&", "&amp;");
                    o = StringUtil.changeString(o, "<", "&lt;");
                    o = StringUtil.changeString(o, ">", "&gt;");
                    o = StringUtil.changeString(o, "'", "&#039;");
                    o = StringUtil.changeString(o, "\"", "&#034;");
                    o = StringUtil.changeString(o, "\n", "<br />");
                    pageContext.getOut().print(o);
                }
            }
            else {
                pageContext.getOut().print( x ) ;
            }
        } catch (Exception e) {
            throw new JspException(e);
        }
        return SKIP_BODY;
    }

    public int doEndTag() {
        return EVAL_PAGE;
    }
}
