package org.maachang.engine.servlet ;

import java.io.IOException;
import java.util.Hashtable;

import org.maachang.engine.conf.Config;
import org.maachang.engine.validate.ValidateElement;

/**
 * Validate管理オブジェクト.
 * 
 * @version 2007/10/24
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class ValidateManager {
    
    /**
     * Validate管理情報.
     */
    private Hashtable<String,ValidateElement> man = null ;
    
    /**
     * コンストラクタ.
     */
    private ValidateManager() {
        man = new Hashtable<String,ValidateElement>() ;
    }
    
    /**
     * Validateマネージャを生成.
     * <BR><BR>
     * Validateマネージャを生成します.
     * <BR>
     * @param config 対象のコンフィグ情報を設定します.
     * @return ValidateManager 生成されたValidateマネージャが返されます.
     * @exception Exception 例外.
     */
    protected static final ValidateManager getValidateManager( Config config )
        throws Exception {
        if( config == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        ValidateManager ret = new ValidateManager() ;
        String[] names = config.getAll( "validate","package" ) ;
        if( names != null && names.length > 0 ) {
            int len = names.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( names[ i ] == null || ( names[ i ] = names[ i ].trim() ).length() <= 0 ) {
                    continue ;
                }
                ret.add( names[ i ] ) ;
            }
        }
        return ret ;
    }
    
    /**
     * 指定パッケージのValidate要素オブジェクトを設定.
     * <BR><BR>
     * 指定されたパッケージ内容のValidate要素オブジェクトを設定します.
     * <BR>
     * @param name 対象のパッケージ名を設定します.
     * @exception Exception 例外.
     */
    protected void add( String name ) throws Exception {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        Object obj = Class.forName( name ).newInstance() ;
        if( ( obj instanceof ValidateElement ) == false ) {
            throw new IOException( "指定パッケージ名["+name+
                "]はValidateElementではありません" ) ;
        }
        String terget = ( ( ValidateElement )obj ).getName() ;
        if( terget == null || ( terget = terget.trim() ).length() <= 0 ) {
            throw new IOException( "指定パッケージ名["+name+"]のValidate名は不正です" ) ;
        }
        man.put( terget.toLowerCase(),( ValidateElement )obj ) ;
    }
    
    /**
     * 指定Validate要素オブジェクトを取得.
     * <BR><BR>
     * 指定Validate名の要素Validateオブジェクトを取得します.
     * <BR>
     * @param name 対象のValidate名を設定します.
     * @return ValidateElement 対象のValidateオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public ValidateElement get( String name ) throws Exception {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "指定ValidateElement名は不正です" ) ;
        }
        ValidateElement ret = man.get( name.toLowerCase() ) ;
        if( ret == null ) {
            throw new IOException( "指定Validate名[" + name + "]は存在しません" ) ;
        }
        return ret ;
    }
}
