package org.maachang.engine.servlet ;

import java.io.IOException;

import org.maachang.engine.validate.ValidateElement;

/**
 * Validate処理用オブジェクト.
 * 
 * @version 2007/10/24
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class Validate {
    
    /**
     * 処理結果メッセージ.
     */
    private ResultMessage result = null ;
    
    /**
     * リクエストパラメータ.
     */
    private Parameter params = null ;
    
    /**
     * エラーフォワード先.
     */
    private String errorForward = null ;
    
    /**
     * コンストラクタ.
     */
    private Validate() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * Validateを生成します.
     * <BR>
     * @param result 処理結果のメッセージを設定します.
     * @param params リクエストパラメータを設定します.
     * @exception Exception 例外.
     */
    protected Validate( ResultMessage result,Parameter params )
        throws Exception {
        if( result == null || params == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.result = result ;
        this.params = params ;
    }
    
    /**
     * エラーフォワード先を設定.
     * <BR><BR>
     * エラーフォワード先を設定します.<BR>
     * また、この条件を設定しないと、Validate#append()処理で、例外が発生します.
     * <BR>
     * @param errorForward エラーフォワード先を設定します.
     * @exception Exception 例外.
     */
    public void setErrorForward( String errorForward )
        throws Exception {
        if( errorForward == null || ( errorForward = errorForward.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.errorForward = errorForward ;
    }
    
    /**
     * Validate処理を追加.
     * <BR><BR>
     * Validate処理を追加します.
     * <BR>
     * @param name 対象のValidate名を設定します.
     * @param target ターゲット要素名を設定します.
     * @param message Validateがマッチした場合のエラーメッセージを設定します.
     * @return Validate Validateオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public Validate append( String name,String target,String message )
        throws Exception {
        return append( name,target,message,( String[] )null ) ;
    }
    
    /**
     * Validate処理を追加.
     * <BR><BR>
     * Validate処理を追加します.
     * <BR>
     * @param name 対象のValidate名を設定します.
     * @param target ターゲット要素名を設定します.
     * @param message Validateがマッチした場合のエラーメッセージを設定します.
     * @param args Validateパラメータを設定します.
     * @return Validate Validateオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public Validate append( String name,String target,String message,String... args )
        throws Exception {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "Validate名が指定されていません" ) ;
        }
        if( target == null || ( target = target.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "ターゲット要素名が指定されていません" ) ;
        }
        if( message == null || ( message = message.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "エラーメッセージが設定されていません" ) ;
        }
        Object param = params.getObject( target ) ;
        if( param == null ) {
            throw new IllegalArgumentException( "指定ターゲット要素名["+target+"]はパラメータに存在しません" ) ;
        }
        if( this.errorForward == null ) {
            throw new IOException( "エラーフォワード先が設定されていません.(Validate#setErrorForward()を設定してください)" ) ;
        }
        ValidateElement emt = GlobalInfo.getValidateManager().get( name ) ;
        if( emt.match( param,args ) == false ) {
            if( result.getErrorMessage() != null ) {
                result.setErrorMessage(
                    new StringBuilder().append( result.getErrorMessage() ).
                    append( "<BR>" ).append( message ).toString() ) ;
            }
            else {
                result.setErrorMessage( message ) ;
            }
        }
        return this ;
    }
    
    /**
     * Validate処理結果を取得.
     * <BR><BR>
     * Validate処理結果を取得します.
     * <BR>
     * @return boolean [true]の場合、Validateにマッチした条件が存在します.
     */
    public boolean isValidate() {
        return ( result.getState() == ResultMessage.ERROR ) ? true : false ;
    }
    
    /**
     * エラーフォワード先を取得.
     * <BR><BR>
     * 設定されているエラーフォワード先を取得します.
     * <BR>
     * @return String エラーフォワード先が返されます.
     */
    public String getErrorFroward() {
        return errorForward ;
    }
    
    /**
     * 処理結果メッセージを取得.
     * <BR><BR>
     * 処理結果メッセージを取得します.
     * <BR>
     * @return ResultMessage 処理結果メッセージが返されます.
     */
    public ResultMessage getResultMessage() {
        return result ;
    }
    
    /**
     * パラメータを取得.
     * <BR><BR>
     * パラメータを取得します.
     * <BR>
     * @return Parameter パラメータが返されます.
     */
    public Parameter getParameter() {
        return params ;
    }
}
