package org.maachang.engine.servlet;

import java.util.HashMap;
import java.util.Hashtable;

/**
 * ThreadLocal管理.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
class ThreadLocalParam {
    private Hashtable<String, HashMap<String, Object>> params = new Hashtable<String, HashMap<String, Object>>();

    private ThreadLocalParam() {
    }

    private static final ThreadLocalParam SNGL = new ThreadLocalParam();

    public static final ThreadLocalParam getInstance() {
        return SNGL;
    }

    private String getLocalName() {
        return Thread.currentThread().getName();
    }

    public void clear() {
        params.get(getLocalName());
    }

    public void put(String key, Object val) {
        String t = getLocalName() ;
        HashMap<String, Object> o = params.get(t);
        if (o == null) {
            o = new HashMap<String, Object>();
            params.put(t, o);
        }
        o.put(key, val);
    }

    public Object get(String key) {
        HashMap<String, Object> o = params.get(getLocalName());
        if (o == null) {
            return null;
        }
        return o.get(key);
    }
}
