package org.maachang.engine.servlet;

/**
 * 処理結果メッセージ保持オブジェクト.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
class ResultMessageImpl implements ResultMessage {
    private int state = SUCCESS;

    private String errorMessage = null;

    private String successMessage = null;

    public ResultMessageImpl() {

    }

    public int getState() {
        return this.state;
    }

    public void setSuccessMessage(String message) {
        if (message == null || (message = message.trim()).length() <= 0) {
            message = null;
        }
        this.successMessage = message;
        state = SUCCESS;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void setErrorMessage(String message) {
        if (message == null || (message = message.trim()).length() <= 0) {
            message = null;
        }
        this.errorMessage = message;
        state = ERROR;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }


}
