package org.maachang.engine.servlet;

/**
 * 処理結果メッセージを保持.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public interface ResultMessage {
    /**
     * ステータス情報を保持する名前.
     */
    public static final String STATE = "actionState";
    
    /**
     * 正常メッセージを保持する名前.
     */
    public static final String SUCCESS_MESSAGE = "successActionMessage";
    
    /**
     * エラーメッセージを保持する名前.
     */
    public static final String ERROR_MESSAGE = "errorActionMessage";
    
    /**
     * ステータス : 正常.
     */
    public static final int SUCCESS = 0;
    
    /**
     * ステータス : エラー.
     */
    public static final int ERROR = 1;
    
    /**
     * ステータスを取得.
     * <BR>
     * @return int ステータスが返されます.
     */
    public int getState() ;
    
    /**
     * 正常メッセージを設定.
     * <BR>
     * @param message 正常のメッセージを設定します.
     */
    public void setSuccessMessage(String message) ;
    
    /**
     *エラーメッセージを取得.
     * <BR>
     * @return String エラーメッセージが返されます.
     */
    public String getErrorMessage() ;
    
    /**
     * エラーメッセージを設定.
     * <BR>
     * @param message エラーメッセージを設定します.
     */
    public void setErrorMessage(String message) ;
    
    /**
     * 正常メッセージを取得.
     * <BR>
     * @return String 正常メッセージが返されます.
     */
    public String getSuccessMessage() ;
}
