package org.maachang.engine.servlet;

import javax.servlet.http.HttpServletRequest;

/**
 * パラメータオブジェクト.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
class ParameterImpl extends AbstractParameter implements Parameter {
    
    /**
     * HttpServletRequest.
     */
    private HttpServletRequest request = null ;
    
    private ParameterImpl() {}
    public ParameterImpl( HttpServletRequest request ) {
        this.request = request ;
    }
    
    /**
     * 情報取得用.
     * <BR><BR>
     * 情報を取得する処理.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @return Object 対象の情報が返されます.
     */
    protected Object getAbstract( String key ) {
        return request.getAttribute( key ) ;
    }
    
    /**
     * 情報を設定.
     * <BR><BR>
     * 情報を設定する処理.
     * <BR>
     * @param key 対象のキー名を設定.
     * @param value 対象の情報を設定.
     */
    protected void setAbstract( String key,Object value ) {
        request.setAttribute( key,value ) ;
    }
    
}
