package org.maachang.engine.servlet;

import java.util.Date;
import java.util.List;
import java.util.Locale;

/**
 * パラメータ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public interface Parameter {
    
    /**
     * Boolean情報を取得.
     * <BR><BR>
     * Boolean情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return Boolean 情報が返されます.
     */
    public Boolean getBoolean( String name ) ;
    
    /**
     * Boolean情報を設定.
     * <BR><BR>
     * Boolean情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 情報を設定します.
     */
    public void setBoolean( String name,Boolean value ) ;
    
    /**
     * Integer情報を取得.
     * <BR><BR>
     * Integer情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return Integer 情報が返されます.
     */
    public Integer getInteger( String name ) ;
    
    /**
     * Integer情報を設定.
     * <BR><BR>
     * Integer情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 情報を設定します.
     */
    public void setInteger( String name,Integer value ) ;
    
    /**
     * Long情報を取得.
     * <BR><BR>
     * Long情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return Long 情報が返されます.
     */
    public Long getLong( String name ) ;
    
    /**
     * Long情報を設定.
     * <BR><BR>
     * Long情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 情報を設定します.
     */
    public void setLong( String name,Long value ) ;
    
    /**
     * Float情報を取得.
     * <BR><BR>
     * Float情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return Float 情報が返されます.
     */
    public Float getFloat( String name ) ;
    
    /**
     * Float情報を設定.
     * <BR><BR>
     * Float情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 情報を設定します.
     */
    public void setFloat( String name,Float value ) ;
    
    /**
     * Double情報を取得.
     * <BR><BR>
     * Double情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return Double 情報が返されます.
     */
    public Double getDouble( String name ) ;
    
    /**
     * Double情報を設定.
     * <BR><BR>
     * Double情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 情報を設定します.
     */
    public void setDouble( String name,Double value ) ;
    
    /**
     * String情報を取得.
     * <BR><BR>
     * String情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return String 情報が返されます.
     */
    public String getString( String name ) ;
    
    /**
     * String情報を設定.
     * <BR><BR>
     * String情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 情報を設定します.
     */
    public void setString( String name,String value ) ;
    
    /**
     * Date情報を取得.
     * <BR><BR>
     * Date情報を取得します.
     * <BR>
     * @param format フォーマット情報を設定します.
     * @param locale 対象のロケールを設定します.
     * @param name 対象の名前を設定します.
     * @return Date 情報が返されます.
     */
    public Date getDate( String format,String name ) ;
    
    /**
     * Date情報を設定.
     * <BR><BR>
     * Date情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param format フォーマット情報を設定します.
     * @param locale 対象のロケールを設定します.
     * @param value 情報を設定します.
     */
    public void setDate( String name,String format,Date value ) ;
    
    /**
     * Date情報を取得.
     * <BR><BR>
     * Date情報を取得します.
     * <BR>
     * @param format フォーマット情報を設定します.
     * @param locale 対象のロケールを設定します.
     * @param name 対象の名前を設定します.
     * @return Date 情報が返されます.
     */
    public Date getDate( String format,Locale locale,String name ) ;
    
    /**
     * Date情報を設定.
     * <BR><BR>
     * Date情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param format フォーマット情報を設定します.
     * @param locale 対象のロケールを設定します.
     * @param value 情報を設定します.
     */
    public void setDate( String name,String format,Locale locale,Date value ) ;
    
    /**
     * List情報を取得.
     * <BR><BR>
     * List情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return List 情報が返されます.
     */
    public List getList( String name ) ;
    
    /**
     * List情報を設定.
     * <BR><BR>
     * List情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 情報を設定します.
     */
    public void setList( String name,List value ) ;
    
    /**
     * HttpBinary情報を取得.
     * <BR><BR>
     * HttpBinary情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return HttpBinary 情報が返されます.
     */
    public HttpBinary getHttpBinary( String name ) ;
    
    /**
     * Object情報を取得.
     * <BR><BR>
     * Object情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return Object 情報が返されます.
     */
    public Object getObject( String name ) ;
    
    /**
     * 指定Bean情報からパラメータ群を取得.
     * <BR><BR>
     * 指定Bean情報からパラメータ群を取得します.
     * <BR>
     * @param cls 対象のBeanクラスを設定します.
     * @return Object 対象の情報が返されます.
     * @exception Exception 例外.
     */
    public Object getBean( Class cls ) throws Exception ;
    
    /**
     * 指定Bean情報からパラメータ群を取得.
     * <BR><BR>
     * 指定Bean情報からパラメータ群を取得します.
     * <BR>
     * @param object 対象のBeanオブジェクトを設定します.
     * @exception Exception 例外.
     */
    public void getBean( Object object ) throws Exception ;
    
    /**
     * 指定Bean情報をパラメータ群に設定.
     * <BR><BR>
     * 指定Bean情報をパラメータ群に設定します.
     * <BR>
     * @param object 設定対象のオブジェクトを設定します.
     * @exception Exception 例外.
     */
    public void setBean( Object object ) throws Exception ;
    
    /**
     * 更新内容のキー名を取得.
     * <BR><BR>
     * 更新内容のキー名を取得します.
     * <BR>
     * @return Object[] 更新内容キーが返されます.
     */
    public Object[] getUpdateKeys() ;
    
}
