package org.maachang.engine.servlet;

/**
 * ページセッション.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public interface PageSession {
    
    /**
     * セッション内容をクリア.
     * <BR><BR>
     * セッション内容をクリアします.
     */
    public void clear() ;
    
    /**
     * セッションIDを取得.
     * <BR><BR>
     * セッションIDを取得します.
     * <BR>
     * @return String セッションIDが返されます.
     */
    public String getSessionId() ;
    
    /**
     * セッション生成時間を取得.
     * <BR><BR>
     * セッション生成時間を取得します.
     * <BR>
     * @return long セッション生成IDが返されます.
     */
    public long getCreateTime() ;
    
    /**
     * セッション更新時間を取得.
     * <BR><BR>
     * セッション更新時間が返されます.
     * <BR>
     * @return long セッション更新時間が返されます.
     */
    public long getUpdateTime() ;
    
    /**
     * セッション情報を登録.
     * <BR><BR>
     * セッション情報を登録します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param value 対象の要素を設定します.
     */
    public void put( String key,Object value ) ;
    
    /**
     * セッション情報を取得.
     * <BR><BR>
     * セッション情報を取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @return Object セッション情報が返されます.
     */
    public Object get( String key ) ;
    
    /**
     * セッション情報を削除.
     * <BR><BR>
     * セッション情報を削除します.
     * <BR>
     * @param key 対象のキー名を設定します.
     */
    public void remove( String key ) ;
}

