package org.maachang.engine.servlet;

import java.util.HashMap;

/**
 * オブジェクト群を名前管理するマネージャ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
class NamingByObjectManager {

    /**
     * データ管理オブジェクト.
     */
    private final HashMap<String, Object> manager = new HashMap<String, Object>();

    /**
     * シングルトン.
     */
    private static final NamingByObjectManager SNGL = new NamingByObjectManager();

    /**
     * コンストラクタ.
     */
    private NamingByObjectManager() {
    }

    /**
     * オブジェクト情報を取得. <BR>
     * <BR>
     * オブジェクト情報を取得します. <BR>
     * 
     * @return NamingByObjectManager オブジェクト情報が返されます.
     */
    public static final NamingByObjectManager getInstance() {
        return SNGL;
    }

    /**
     * 条件を設定. <BR>
     * <BR>
     * 条件を設定します. <BR>
     * 
     * @param name
     *            設定対象要素名を設定します.
     * @param value
     *            設定対象要素内容を設定します.
     */
    public synchronized void put(String name, Object value) {
        this.manager.put(name, value);
    }

    /**
     * 条件を削除. <BR>
     * <BR>
     * 条件を削除します. <BR>
     * 
     * @param name
     *            削除対象の条件名を設定します.
     */
    public synchronized void remove(String name) {
        this.manager.remove(name);
    }

    /**
     * 条件を取得. <BR>
     * <BR>
     * 条件を取得します. <BR>
     * 
     * @param name
     *            取得対象の条件名を設定します.
     * @return Object 条件名に対する要素情報が返されます.
     */
    public synchronized Object get(String name) {
        return this.manager.get(name);
    }

    /**
     * 設定条件数を取得. <BR>
     * <BR>
     * 設定されている条件数を取得します. <BR>
     * 
     * @return int 設定されている条件数が返されます.
     */
    public synchronized int size() {
        return this.manager.size();
    }

    /**
     * 設定条件名群を取得. <BR>
     * <BR>
     * 設定されている条件名群を取得します. <BR>
     * 
     * @return String[] 設定されている条件名群が返されます.
     */
    public synchronized String[] getNames() {
        if (this.manager.size() > 0) {
            Object[] objs = this.manager.keySet().toArray();
            int len = objs.length;
            String[] ret = new String[len];
            for (int i = 0; i < len; i++) {
                ret[i] = (String) objs[i];
            }
            return ret;
        }
        return null;
    }

    /**
     * 対象名が存在するかチェック. <BR>
     * <BR>
     * 対象名が存在するかチェックします. <BR>
     * 
     * @param name
     *            チェック対象の条件名を設定します.
     * @return boolean チェック結果が返されます.
     */
    public synchronized boolean isData(String name) {
        return (this.manager.get(name) == null) ? false : true;
    }
}
