package org.maachang.engine.servlet;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * MaaEngineListener
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class MaaEngineListener implements ServletContextListener {
    
    /**
     * LOG.
     */
    protected static final Log LOG = LogFactory.getLog(MaaEngineListener.class) ;
    
    /**
     * 読み込みコンフィグ名.
     */
    private static final String READ_CONFIG = "config";
    
    /**
     * 初期処理.
     * <BR><BR>
     * 初期処理を実行します.
     * <BR>
     * @param sce サーブレットコンテキストイベント.
     */
    public void contextInitialized( ServletContextEvent sce ) {
        String config = ( String )sce.getServletContext().getInitParameter( READ_CONFIG ) ;
        String realPath = sce.getServletContext().getRealPath( "." ) ;
        
        LOG.info( "####>> startup." ) ;
        LOG.info( "## config:" + config ) ;
        LOG.info( "## realPath:" + realPath ) ;
        try {
            InitServlet.getInstance().init( config,realPath );
            DownloadMonitor._init() ;
        } catch( Exception e ) {
            LOG.error( "# エラーが発生しました",e ) ;
        }
    }
    
    /**
     * 終了処理.
     * <BR><BR>
     * 終了処理を実行します.
     * <BR>
     * @param sce サーブレットコンテキストイベント.
     */
    public void contextDestroyed( ServletContextEvent sce ) {
        LOG.info( "####>> shutdown." ) ;
        DownloadMonitor._destroy() ;
        if( GlobalInfo.getPageSessionManager() != null ) {
            GlobalInfo.getPageSessionManager().destroy() ;
        }
    }
    
}
