package org.maachang.engine.servlet;

import java.util.HashMap;
import java.util.Hashtable;

/**
 * ローカルセッションを取得.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
class LocalSession {
    
    /**
     * ローカルセッション管理名.
     */
    private static final String LOCAL_SESSION = "LOCAL_SESSION" ;
    
    /**
     * ローカルセッション管理
     */
    private HashMap<String,Object> man = null ;
    
    /**
     * コンストラクタ.
     */
    private LocalSession() {
        man = new HashMap<String,Object>() ;
    }
    
    /**
     * マネージャを取得.
     */
    private static final Hashtable<String,LocalSession> getManager() {
        NamingByObjectManager nm = NamingByObjectManager.getInstance() ;
        Hashtable<String,LocalSession> ret = null ;
        synchronized( LOCAL_SESSION ) {
            ret = ( Hashtable<String,LocalSession> )nm.get( LOCAL_SESSION ) ;
            if( ret == null ) {
                ret = new Hashtable<String,LocalSession>() ;
                nm.put( LOCAL_SESSION,ret ) ;
            }
        }
        return ret ;
    }
    
    /**
     * ローカルセッションを取得.
     * <BR><BR>
     * ローカルセッションを取得します.
     * <BR>
     * @return LocalSession ローカルセッションを取得します.
     */
    public static final LocalSession getLocalSession() {
        Hashtable<String,LocalSession> ls = getManager() ;
        String name = Thread.currentThread().getName() ;
        LocalSession ret = ls.get( name ) ;
        if( ret == null ) {
            ret = new LocalSession() ;
            ls.put( name,ret ) ;
        }
        return ret ;
    }
    
    /**
     * ローカルセッションをクリア.
     * <BR><BR>
     * ローカルセッションをクリアします.
     */
    protected static final void clearLocalSession() {
        Hashtable<String,LocalSession> ls = getManager() ;
        ls.remove( Thread.currentThread().getName() ) ;
    }
    
    /**
     * 指定条件を設定.
     * <BR><BR>
     * 指定条件を設定します.
     * <BR>
     * @param name キー名を設定します.
     * @param value 情報を設定します.
     */
    public void put( String name,String value ) {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            return ;
        }
        man.put( name,value ) ;
    }
    
    /**
     * 指定条件を取得.
     * <BR><BR>
     * 指定条件を取得します.
     * <BR>
     * @param name キー名を設定します.
     * @return Object 対象情報が返されます.
     */
    public Object get( String name ) {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            return null ;
        }
        return man.get( name ) ;
    }
    
    /**
     * 指定条件を削除.
     * <BR><BR>
     * 指定条件を削除します.
     * <BR>
     * @param name キー名を設定します.
     */
    public void remove( String name ) {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            return ;
        }
        man.remove( name ) ;
    }
}
