package org.maachang.engine.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.maachang.dao.dbms.Record;

/**
 * ローカル変数.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class LocalInfo {
    public static final String REQUEST_LOCAL_NAME = "REQUEST_LOCAL_NAME";
    public static final String RESPONSE_LOCAL_NAME = "RESPONSE_LOCAL_NAME";
    public static final String RECORD_LOCAL_NAME = "RECORD_LOCAL_NAME";
    public static final String INNER_SESSION = "INNER_SESSION" ;
    
    public static final void clear() {
        ThreadLocalParam.getInstance().clear() ;
    }
    public static final HttpServletRequest getRequest() {
        return (HttpServletRequest)ThreadLocalParam.getInstance().get(REQUEST_LOCAL_NAME) ;
    }
    public static final HttpServletResponse getResponse() {
        return (HttpServletResponse)ThreadLocalParam.getInstance().get(RESPONSE_LOCAL_NAME) ;
    }
    public static final Record getRecord() {
        return (Record)ThreadLocalParam.getInstance().get(RECORD_LOCAL_NAME) ;
    }
    public static final PageSession getInnerSession() {
        return (PageSession)ThreadLocalParam.getInstance().get(INNER_SESSION) ;
    }
}
