package org.maachang.engine.servlet;

import org.apache.velocity.app.Velocity;
import org.maachang.dao.dbms.DbmsInfo;
import org.maachang.dao.dbms.RecordFactory;
import org.maachang.engine.conf.Config;
import org.maachang.engine.util.FileUtil;

/**
 * Servlet初期化.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
class InitServlet {

    /**
     * デフォルトページセッションマネージャタイムアウト.
     */
    private static final long DEF_TIMETOUT = 60L * 30L * 1000L ;

    /**
     * プロパティ読み込みファイル.
     */
    private static final String PROPERTY_FILE = "maaEngine.conf";

    /**
     * オブジェクト.
     */
    private static final InitServlet SNGL = new InitServlet();

    /**
     * スタートアップフラグ.
     */
    private boolean initServletFlag = false;

    /**
     * オブジェクトを取得.
     */
    public static final InitServlet getInstance() {
        return SNGL;
    }

    /**
     * スタートアップが開始しているかチェック.
     */
    public synchronized boolean isStartup() {
        return initServletFlag ;
    }
    
    /**
     * スタートアップ処理.
     */
    public synchronized void init( String readConfig,String realPath )
        throws Exception {
        if (initServletFlag == false) {
            
            if( readConfig == null || ( readConfig = readConfig.trim() ).length() <= 0 ) {
                readConfig = PROPERTY_FILE ;
            }
            
            // リアルパスを整形.
            realPath = FileUtil.getFullPath( realPath ) ;
            
            // コンフィグ情報を取得.
            Config conf = getIniParams( realPath,readConfig ) ;
            
            // DBオブジェクトを取得.
            RecordFactory rec = DbmsInfo.getRecordFactory( conf ) ;
            
            // RealPathを登録.
            GlobalInfo.setRealPath( realPath ) ;
            
            // DBMSオブジェクトを登録.
            GlobalInfo.setRecordFactory( rec ) ;
            
            // DIコンテナを登録.
            GlobalInfo.setDiContainer( new DiContainer() ) ;
            
            // サポートDB種別を設定.
            GlobalInfo.setKind( rec.getSupportKind() ) ;
            
            // コンフィグ情報を設定.
            GlobalInfo.setConfig( conf ) ;
            
            // velocity初期化.
            Velocity.init() ;
            
            // PageSessioMangerを設定.
            GlobalInfo.setPageSessionManager( this.getPageSessionManager( conf ) ) ;
            
            // Validateオブジェクトを設定.
            GlobalInfo.setValidateManager( ValidateManager.getValidateManager( conf ) ) ;
            
            // スタートアップ完了.
            initServletFlag = true;
        }
    }
    
    /**
     * Configファイルを取得.
     */
    private Config getIniParams( String realPath,String readConfig )
        throws Exception {
        String web_inf = FileUtil.marge( realPath,"WEB-INF" ) ;
        String confFile = FileUtil.marge( web_inf,readConfig ) ;
        if( FileUtil.isFileExists( confFile ) == true ) {
            return DbmsInfo.getConfig( confFile ) ;
        }
        else {
            return DbmsInfo.getConfig(
                Thread.currentThread().
                getContextClassLoader().
                getResourceAsStream( readConfig ) ) ;
        }
    }
    
    /**
     * ページセッションマネージャを取得.
     */
    private PageSessionManager getPageSessionManager( Config config ) {
        long time = config.getInt( "pageSession","timeout",0 ) ;
        if( time == -1L ) {
            time = DEF_TIMETOUT ;
        }
        return new PageSessionManager( time ) ;
    }
}
