package org.maachang.engine.servlet;

import java.io.InputStream;

/**
 * HTTPバイナリ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public interface HttpBinary {

    /**
     * オリジナルファイル名を取得. <BR>
     * <BR>
     * オリジナルファイル名を取得します. <BR>
     * 
     * @return String 対象のオリジナルファイル名が返されます.
     */
    public String getOriginalName();

    /**
     * MimeTypeを取得. <BR>
     * <BR>
     * MimeTypeを取得します. <BR>
     * 
     * @return String MimeTypeが返されます.
     */
    public String getMimeType();

    /**
     * 対象バイナリを取得. <BR>
     * <BR>
     * 対象のバイナリ情報が返されます. <BR>
     * 
     * @return byte[] 対象のバイナリが返されます.
     */
    public byte[] getBinary();

    /**
     * 対象バイナリを取得. <BR>
     * <BR>
     * 対象のバイナリ情報が返されます. <BR>
     * 
     * @return InputStream 対象のバイナリがInputStreamで返されます.
     */
    public InputStream getInputStream();

    /**
     * 情報長を取得. <BR>
     * <BR>
     * 情報長が返されます. <BR>
     * 
     * @return int 情報長が返されます.
     */
    public int getLength();
}
