package org.maachang.engine.servlet;

import java.util.Hashtable;
import java.util.Set;

import org.maachang.dao.dbms.RecordFactory;
import org.maachang.dao.dbms.kind.SupportKind;
import org.maachang.engine.Action;
import org.maachang.engine.conf.Config;

/**
 * Globalオブジェクト.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class GlobalInfo {
    public static final String REALPATH = "REALPATH" ;
    public static final String RECORD_FACTORY = "RECORD_FACTORY" ;
    public static final String ACTION_OBJECTS = "ACTION_OBJECTS" ;
    public static final String NOT_FORM_OBJECTS = "NOT_FORM_OBJECTS" ;
    public static final String DI_CONTAINER = "DI_CONTAINER" ;
    public static final String MY_KIND = "MY_KIND" ;
    public static final String CONFIG_PARAM = "CONFIG_PARAM" ;
    public static final String PAGE_SESSION_MANAGER = "PAGE_SESSION_MANAGER" ;
    public static final String DOWNLOAD_KEY = "DOWNLOAD_KEY" ;
    public static final String VALIDATE_MANAGER = "VALIDATE_MANAGER" ;
    
    public static final void setRealPath( String realPath ) {
        NamingByObjectManager.getInstance().put( REALPATH,realPath ) ;
    }
    public static final String getRealPath() {
        return ( String )NamingByObjectManager.getInstance().get( REALPATH ) ;
    }
    
    public static final void setRecordFactory( RecordFactory recordFactory ) {
        NamingByObjectManager.getInstance().put( RECORD_FACTORY,recordFactory ) ;
    }
    public static final RecordFactory getRecordFactory() {
        return ( RecordFactory )NamingByObjectManager.getInstance().get( RECORD_FACTORY ) ;
    }
    
    public static final void setActionObject( Hashtable<String,Action> actionMap ) {
        NamingByObjectManager.getInstance().put( ACTION_OBJECTS,actionMap ) ;
    }
    public static final Hashtable<String,Action> getActionObject() {
        return ( Hashtable<String,Action> )NamingByObjectManager.getInstance().get( ACTION_OBJECTS ) ;
    }
    
    public static final void setNotFormObject( Set<String> formMap ) {
        NamingByObjectManager.getInstance().put( NOT_FORM_OBJECTS,formMap ) ;
    }
    public static final Set<String> getNotFormObject() {
        return ( Set<String> )NamingByObjectManager.getInstance().get( NOT_FORM_OBJECTS ) ;
    }
    
    public static final void setDiContainer( DiContainer container ) {
        NamingByObjectManager.getInstance().put( DI_CONTAINER,container ) ;
    }
    public static final DiContainer getDiContainer() {
        return ( DiContainer )NamingByObjectManager.getInstance().get( DI_CONTAINER ) ;
    }
    
    public static final void setKind( SupportKind kind ) {
        NamingByObjectManager.getInstance().put( MY_KIND,kind ) ;
    }
    public static final SupportKind getKind() {
        return ( SupportKind )NamingByObjectManager.getInstance().get( MY_KIND ) ;
    }
    
    public static final void setConfig( Config params ) {
        NamingByObjectManager.getInstance().put( CONFIG_PARAM,params ) ;
    }
    public static final Config getConfig() {
        return ( Config )NamingByObjectManager.getInstance().get( CONFIG_PARAM ) ;
    }
    
    public static final void setPageSessionManager( PageSessionManager manager ) {
        NamingByObjectManager.getInstance().put( PAGE_SESSION_MANAGER,manager ) ;
    }
    
    public static final PageSessionManager getPageSessionManager() {
        return ( PageSessionManager )NamingByObjectManager.getInstance().get( PAGE_SESSION_MANAGER ) ;
    }
    
    public static final Hashtable<String,DownloadInfo> getDownloadKey() {
        Hashtable<String,DownloadInfo> ret = null ;
        NamingByObjectManager nm = NamingByObjectManager.getInstance() ;
        synchronized( nm ) {
            ret = ( Hashtable<String,DownloadInfo> )nm.get( DOWNLOAD_KEY ) ;
            if( ret == null ) {
                ret = new Hashtable<String,DownloadInfo>() ;
                nm.put( DOWNLOAD_KEY,ret ) ;
            }
        }
        return ret ;
    }
    
    public static final void setValidateManager( ValidateManager manager ) {
        NamingByObjectManager.getInstance().put( VALIDATE_MANAGER,manager ) ;
    }
    
    public static final ValidateManager getValidateManager() {
        return ( ValidateManager )NamingByObjectManager.getInstance().get( VALIDATE_MANAGER ) ;
    }
}
