package org.maachang.engine.servlet;

import java.util.Hashtable;

/**
 * ダウンロードモニター.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
class DownloadMonitor extends Thread {
    
    private volatile boolean stopFlag = false ;
    private static DownloadMonitor SNGL = null ;
    
    protected static final void _init() {
        if( SNGL == null ) {
            SNGL = new DownloadMonitor() ;
        }
    }
    protected static final void _destroy() {
        if( SNGL != null ) {
            try {
                SNGL.clear() ;
            } catch( Exception e ) {
            }
            SNGL = null ;
        }
    }
    
    public static final DownloadMonitor getInstance() {
        return SNGL ;
    }
    
    public DownloadMonitor() {
        this.setDaemon( true ) ;
        this.start() ;
    }
    
    protected void finalize() throws Exception {
        this.clear() ;
    }
    
    public void clear() {
        setStop( true ) ;
    }
    
    public synchronized boolean isStop() {
        return stopFlag ;
    }
    
    private synchronized void setStop( boolean mode ) {
        this.stopFlag = mode ;
    }
    
    private static final long TIMEOUT = 30000L ;
    private static final long WAIT_TIME = 1000L ;
    
    public void run() {
        for( ;; ) {
            try {
                sleep( WAIT_TIME ) ;
                if( isStop() == true ) {
                    return ;
                }
                Hashtable<String,DownloadInfo> man = GlobalInfo.getDownloadKey() ;
                if( man != null ) {
                    Object[] key = man.keySet().toArray() ;
                    int len = man.size() ;
                    for( int i = 0 ; i < len ; i ++ ) {
                        DownloadInfo info = man.get( ( String )key[ i ] ) ;
                        if( info != null && info.getCreateTime() + TIMEOUT <= System.currentTimeMillis() ) {
                            man.remove( ( String )key[ i ] ) ;
                        }
                    }
                }
            } catch( InterruptedException ie ) {
                return ;
            } catch ( NullPointerException ne ) {
            } catch( OutOfMemoryError mem ) {
            } catch( Exception e ) {
            }
        }
    }
}
