package org.maachang.engine.servlet;

import java.io.InputStream;

import javax.servlet.http.HttpServletRequest;

/**
 * １つのダウンロード情報.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class DownloadInfo {
    
    /**
     * ダウンロード情報.
     */
    private InputStream stream = null ;
    
    /**
     * MimeType.
     */
    private String mimeType = null ;
    
    /**
     * 生成時間.
     */
    private long createTime = -1L ;
    
    /**
     * ダウンロード対象IPアドレス.
     */
    private String address = null ;
    
    /**
     * ダウンロード対象ユーザエージェント.
     */
    private String userAgent = null ;
    
    /**
     * コンストラクタ.
     */
    private DownloadInfo() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * ダウンロード情報を生成します.
     * <BR>
     * @param request 対象のリクエスト情報を設定します.
     * @param mimeType ダウンロードMimeTypeを設定します.
     * @param binary 対象のバイナリ情報を設定します.
     * @exception Exception 例外.
     */
    protected DownloadInfo( HttpServletRequest request,String mimeType,InputStream stream )
        throws Exception {
        if( request == null || stream == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        if( mimeType == null || ( mimeType = mimeType.trim() ).length() <= 0 ) {
            mimeType = "application/octet-stream" ;
        }
        this.stream = stream ;
        this.mimeType = mimeType ;
        this.address = request.getRemoteAddr() ;
        this.userAgent = request.getHeader( "User-Agent" ) ;
        this.createTime = System.currentTimeMillis() ;
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        if( stream != null ) {
            try {
                stream.close() ;
            } catch( Exception e ) {
            }
        }
        stream = null ;
        mimeType = null ;
        createTime = -1L ;
        address = null ;
        userAgent = null ;
    }
    
    /**
     * ダウンロード情報を取得.
     * <BR><BR>
     * ダウンロード情報を取得します.
     * <BR>
     * @return InputStream ダウンロード情報が返されます.
     */
    public InputStream getInputStream() {
        return stream ;
    }
    
    /**
     * MimeTypeを取得.
     * <BR><BR>
     * MimeTypeを取得します.
     * <BR>
     * @return String MimeTypeが返されます.
     */
    public String getMimeType() {
        return mimeType ;
    }
    
    /**
     * addressを取得.
     * <BR><BR>
     * addressを取得します.
     * <BR>
     * @return String addressが返されます.
     */
    public String getAddress() {
        return address ;
    }
    
    /**
     * userAgentを取得.
     * <BR><BR>
     * userAgentを取得します.
     * <BR>
     * @return String userAgentが返されます.
     */
    public String getUserAgent() {
        return userAgent ;
    }
    
    /**
     * 生成時間を取得.
     * <BR><BR>
     * 生成時間を取得します.
     * <BR>
     * @return long 生成時間が返されます.
     */
    public long getCreateTime() {
        return createTime ;
    }
    
}
