package org.maachang.engine.servlet;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.maachang.engine.util.RandomUtil;

/**
 * ダウンロード用サーブレット.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class DownloadFilter implements Filter {
    
    /**
     * ダウンロードパラメータ.
     */
    public static final String DOWNLOAD_PARAM = "_downloadId" ;
    
    /**
     * ダウンロードキー長.
     */
    public static final int DOWNLOAD_KEY_LENGTH = 48 ;
    
    /**
     * リクエストパラメータキャラクタセット.
     */
    private static final String CHARSET = "UTF8" ;
    
    /**
     * 初期処理.
     * <BR><BR>
     * フィルタ初期処理.
     * <BR>
     * @param filterConfig フィルタコンフィグ.
     * @exception ServletException サーブレット例外.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
    }
    
    /**
     * 後処理.
     * <BR><BR>
     * フィルタ後処理.
     */
    public void destroy() {
    }
    
    /**
     * ダウンロードフィルタ.
     * <BR><BR>
     * ダウンロード処理を行うフィルター処理.
     * <BR>
     * @param request 対象のリクエストオブジェクトが設定されます.
     * @param response 対象のレスポンスオブジェクトが設定されます.
     * @param chain フィルタチェインが設定されます.
     * @exception IOException IO例外.
     * @exception ServletException サーブレット例外.
     */
    public void doFilter( ServletRequest request,ServletResponse response,FilterChain chain )
        throws IOException,ServletException {
        request.setCharacterEncoding(CHARSET) ;
        String downloadId = null ;
        if( ( downloadId = request.getParameter( DOWNLOAD_PARAM ) ) != null &&
            ( downloadId = downloadId.trim() ).length() == DOWNLOAD_KEY_LENGTH ) {
            
            Hashtable<String,DownloadInfo> man = GlobalInfo.getDownloadKey() ;
            DownloadInfo di = man.remove( downloadId ) ;
            
            if( di == null ||
                request.getRemoteAddr().equals( di.getAddress() ) == false ||
                ( ( HttpServletRequest )request ).getHeader( "User-Agent" ).equals( di.getUserAgent() ) == false ) {
                throw new IOException( "指定キーの情報("+downloadId+")は不正です" ) ;
            }
            
            response.setContentType( di.getMimeType() ) ;
            InputStream is = di.getInputStream() ;
            OutputStream out = new BufferedOutputStream( response.getOutputStream() ) ;
            for( ;; ) {
                int b = is.read() ;
                if( b == -1 ) {
                    break ;
                }
                out.write( b ) ;
            }
            out.flush() ;
            out.close() ;
        }
        else {
            chain.doFilter( request,response ) ;
        }
    }
    
    /**
     * ダウンロード情報を設定.
     * <BR><BR>
     * ダウンロード情報を設定します.
     * <BR>
     * @param request 対象のリクエスト情報を設定します.
     * @param mimeType ダウンロードMimeTypeを設定します.
     * @param binary 対象のバイナリ情報を設定します.
     * @exception Exception 例外.
     */
    public static final String setDownloadInfo( HttpServletRequest request,String mimeType,InputStream stream )
        throws Exception {
        Hashtable<String,DownloadInfo> man = GlobalInfo.getDownloadKey() ;
        for( ;; ) {
            String key = RandomUtil.randomString( DOWNLOAD_KEY_LENGTH,true,true,true ) ;
            synchronized( man ) {
                if( man.get( key ) == null ) {
                    man.put( key,new DownloadInfo( request,mimeType,stream ) ) ;
                    return key ;
                }
            }
            try { Thread.sleep( 30L ) ; } catch( Exception e ) {}
        }
    }
}
