package org.maachang.engine.servlet;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;

import org.maachang.engine.Action;
import org.maachang.engine.util.Reflect;

/**
 * DIコンテナ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class DiContainer {
    
    /**
     * DI対象オブジェクト名.
     */
    private static final String[] TARGET_OBJECT = {
        "Action","Dao","Service" } ;
    
    /**
     * DI管理.
     */
    private Hashtable<String,Object> manager = null ;
    
    /**
     * コンストラクタ.
     */
    public DiContainer() {
        manager = new Hashtable<String,Object>() ;
    }
    
    /**
     * 指定Actionに対して定義オブジェクトを付与.
     * <BR><BR>
     * 指定Actionに対してDIオブジェクトを付与します.
     * <BR>
     * @param action 対象のActionオブジェクトを設定します.
     * @exceptino Exception 例外.
     */
    public void setAction( Action action )
        throws Exception {
        if( action == null ) {
            throw new IllegalArgumentException( "指定Actionは不正です" ) ;
        }
        HashSet<String> history = new HashSet<String>() ;
        int[] cnt = new int[ 1 ] ;
        cnt[ 0 ] = 0 ;
        settingDi( cnt,history,action ) ;
    }
    
    /**
     * 指定Objectに対して定義オブジェクトを付与.
     * <BR><BR>
     * 指定Objectに対してDIオブジェクトを付与します.
     * <BR>
     * @param object 対象のオブジェクトを設定します.
     * @exceptino Exception 例外.
     */
    public void setObject( Object object )
        throws Exception {
        if( object == null ) {
            throw new IllegalArgumentException( "指定Actionは不正です" ) ;
        }
        HashSet<String> history = new HashSet<String>() ;
        int[] cnt = new int[ 1 ] ;
        cnt[ 0 ] = 1 ;
        settingDi( cnt,history,object ) ;
    }
    
    /**
     * オブジェクト内のDI対象条件を付与.
     */
    private boolean settingDi( int[] cnt,HashSet<String> history,Object object )
        throws Exception {
        if( object == null ) {
            throw new IOException( "指定オブジェクトは不正です" ) ;
        }
        String thisObjectName = object.getClass().getName() ;
        // DIコンテナ管理に既に格納されている場合は、処理しない.
        if( manager.get( thisObjectName ) != null ) {
            return false ;
        }
        manager.put( thisObjectName,object ) ;
        // historyに既に格納されている場合は、処理しない.
        if( history.contains( thisObjectName ) == true ) {
            return false ;
        }
        history.add( object.getClass().getName() ) ;
        // Top以外のActionを検出した場合(つまり、先頭のAction以下にActionが定義されている場合).
        if( cnt[ 0 ] != 0 && object.getClass().getName().endsWith( TARGET_OBJECT[ 0 ] ) ) {
            return false ;
        }
        // メソッド一覧を取得.
        ArrayList<Method> lst = Reflect.getMethodObjectList( object ) ;
        int len = lst.size() ;
        int lenJ = TARGET_OBJECT.length ;
        for( int i = 0 ; i < len ; i ++ ) {
            Class target = null ;
            Method md = lst.remove( 0 ) ;
            String name = md.getName() ;
            // setメソッドの場合は、処理対象の可能性がある.
            if( name.startsWith( "set" ) ) {
                for( int j = 0 ; j < lenJ ; j ++ ) {
                    if( name.endsWith( TARGET_OBJECT[ j ] ) ) {
                        Class[] params = md.getParameterTypes() ;
                        // DI対象のメソッドであるかチェック.
                        if( params.length == 1 ) {
                            String paramName = params[ 0 ].getName() ;
                            if( paramName.indexOf( "$" ) == -1 &&
                                paramName.endsWith( TARGET_OBJECT[ j ] ) ) {
                                // DI対象メソッドの場合は、ターゲットとする.
                                target = params[ 0 ] ;
                                break ;
                            }
                        }
                    }
                }
            }
            // DI対象ターゲットが検出された.
            if( target != null ) {
                String key = target.getName() ;
                Object useManObj = null ;
                // DIマネージャに登録されていない.
                if( ( useManObj = manager.get( key ) ) == null ) {
                    // オブジェクトを生成して、マネージャに登録.
                    Object o = target.newInstance() ;
                    if( o != null ) {
                        // メソッドに追加可能な場合.
                        if( settingDi( cnt,history,o ) == true ) {
                            Reflect.executionMethod( name,object,o ) ;
                        }
                        cnt[ 0 ] ++ ;
                    }
                }
                // 登録されているDIが、Actionオブジェクトでない場合.
                else if( key.endsWith( TARGET_OBJECT[ 0 ] ) == false ) {
                    Reflect.executionMethod( name,object,useManObj ) ;
                    cnt[ 0 ] ++ ;
                }
            }
        }
        return true ;
    }
}
