package org.maachang.engine.servlet;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

import org.maachang.engine.util.Reflect;

/**
 * Abstractパラメータオブジェクト.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public abstract class AbstractParameter {
    
    /**
     * 更新管理.
     */
    private HashMap<String,Long> updateManager = new HashMap<String,Long>() ;
    
    /**
     * 情報取得用.
     * <BR><BR>
     * 情報を取得する処理.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @return Object 対象の情報が返されます.
     */
    protected abstract Object getAbstract( String key ) ;
    
    /**
     * 情報を設定.
     * <BR><BR>
     * 情報を設定する処理.
     * <BR>
     * @param key 対象のキー名を設定.
     * @param value 対象の情報を設定.
     */
    protected abstract void setAbstract( String key,Object value ) ;
    
    /**
     * Boolean情報を取得.
     * <BR><BR>
     * Boolean情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return Boolean 情報が返されます.
     */
    public Boolean getBoolean( String name ) {
        Object o = getByPrimitive( name ) ;
        if( o != null ) {
            if( o instanceof Boolean ) {
                return ( Boolean )o ;
            }
            boolean ret = new Boolean(false);
            try {
                String data = (String) o;
                if (data != null && (data = data.trim()).length() > 0) {
                    data = data.toLowerCase();
                    if (data.equals("true") || data.equals("on")
                            || data.equals("ok")) {
                        ret = new Boolean(true);
                    }
                }
            } catch (Exception e) {
                ret = new Boolean(false);
            }
            return ret;
        }
        return null ;
    }
    
    /**
     * Boolean情報を設定.
     * <BR><BR>
     * Boolean情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 情報を設定します.
     */
    public void setBoolean( String name,Boolean value ) {
        if( name == null || value == null || ( name = name.trim() ).length() <= 0 ) {
            return ;
        }
        set( name,value.toString() ) ;
    }
    
    /**
     * Integer情報を取得.
     * <BR><BR>
     * Integer情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return Integer 情報が返されます.
     */
    public Integer getInteger( String name ) {
        Object o = getByPrimitive( name ) ;
        if( o != null ) {
            if( o instanceof Integer ) {
                return ( Integer )o ;
            }
            Integer ret = null ;
            String pm = ( String )o ;
            try {
                ret = new Integer( pm ) ;
            } catch( Exception e ) {
                ret = null ;
            }
            int p = -1 ;
            if( ret == null && ( p = pm.indexOf( "." ) ) != -1 ) {
                pm = pm.substring( 0,p ) ;
                try {
                    ret = new Integer( pm ) ;
                } catch( Exception e ) {
                    ret = null ;
                }
            }
            return ret ;
        }
        return null ;
    }
    
    /**
     * Integer情報を設定.
     * <BR><BR>
     * Integer情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 情報を設定します.
     */
    public void setInteger( String name,Integer value ) {
        if( name == null || value == null || ( name = name.trim() ).length() <= 0 ) {
            return ;
        }
        set( name,value.toString() ) ;
    }
    
    /**
     * Long情報を取得.
     * <BR><BR>
     * Long情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return Long 情報が返されます.
     */
    public Long getLong( String name ) {
        Object o = getByPrimitive( name ) ;
        if( o != null ) {
            if( o instanceof Long ) {
                return ( Long )o ;
            }
            Long ret = null ;
            String pm = ( String )o ;
            try {
                ret = new Long( pm ) ;
            } catch( Exception e ) {
                ret = null ;
            }
            int p = -1 ;
            if( ret == null && ( p = pm.indexOf( "." ) ) != -1 ) {
                pm = pm.substring( 0,p ) ;
                try {
                    ret = new Long( pm ) ;
                } catch( Exception e ) {
                    ret = null ;
                }
            }
            return ret ;
        }
        return null ;
    }
    
    /**
     * Long情報を設定.
     * <BR><BR>
     * Long情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 情報を設定します.
     */
    public void setLong( String name,Long value ) {
        if( name == null || value == null || ( name = name.trim() ).length() <= 0 ) {
            return ;
        }
        set( name,value.toString() ) ;
    }
    
    /**
     * Float情報を取得.
     * <BR><BR>
     * Float情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return Float 情報が返されます.
     */
    public Float getFloat( String name ) {
        Object o = getByPrimitive( name ) ;
        if( o != null ) {
            if( o instanceof Float ) {
                return ( Float )o ;
            }
            Float ret = null ;
            try {
                ret = new Float( ( String )o ) ;
            } catch( Exception e ) {
                ret = null ;
            }
            return ret ;
        }
        return null ;
    }
    
    /**
     * Float情報を設定.
     * <BR><BR>
     * Float情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 情報を設定します.
     */
    public void setFloat( String name,Float value ) {
        if( name == null || value == null || ( name = name.trim() ).length() <= 0 ) {
            return ;
        }
        set( name,value.toString() ) ;
    }
    
    /**
     * Double情報を取得.
     * <BR><BR>
     * Double情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return Double 情報が返されます.
     */
    public Double getDouble( String name ) {
        Object o = getByPrimitive( name ) ;
        if( o != null ) {
            if( o instanceof Double ) {
                return ( Double )o ;
            }
            Double ret = null ;
            try {
                ret = new Double( ( String )o ) ;
            } catch( Exception e ) {
                ret = null ;
            }
            return ret ;
        }
        return null ;
    }
    
    /**
     * Double情報を設定.
     * <BR><BR>
     * Double情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 情報を設定します.
     */
    public void setDouble( String name,Double value ) {
        if( name == null || value == null || ( name = name.trim() ).length() <= 0 ) {
            return ;
        }
        set( name,value.toString() ) ;
    }
    
    /**
     * String情報を取得.
     * <BR><BR>
     * String情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return String 情報が返されます.
     */
    public String getString( String name ) {
        Object o = getByPrimitive( name ) ;
        if( o != null ) {
            if( ( o instanceof String ) == false ) {
                return o.toString() ;
            }
            return ( String )o ;
        }
        return null ;
    }
    
    /**
     * String情報を設定.
     * <BR><BR>
     * String情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 情報を設定します.
     */
    public void setString( String name,String value ) {
        if( name == null || value == null || ( name = name.trim() ).length() <= 0 ) {
            return ;
        }
        set( name,value.toString() ) ;
    }
    
    /**
     * Date情報を取得.
     * <BR><BR>
     * Date情報を取得します.
     * <BR>
     * @param format フォーマット情報を設定します.
     * @param locale 対象のロケールを設定します.
     * @param name 対象の名前を設定します.
     * @return Date 情報が返されます.
     */
    public Date getDate( String format,String name ) {
        return getDate( format,null,name ) ;
    }
    
    /**
     * Date情報を設定.
     * <BR><BR>
     * Date情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param format フォーマット情報を設定します.
     * @param locale 対象のロケールを設定します.
     * @param value 情報を設定します.
     */
    public void setDate( String name,String format,Date value ) {
        setDate( name,format,null,value ) ;
    }
    
    /**
     * Date情報を取得.
     * <BR><BR>
     * Date情報を取得します.
     * <BR>
     * @param format フォーマット情報を設定します.
     * @param locale 対象のロケールを設定します.
     * @param name 対象の名前を設定します.
     * @return Date 情報が返されます.
     */
    public Date getDate( String format,Locale locale,String name ) {
        if( format == null || format.length() <= 0 ) {
            return null ;
        }
        Object o = getByPrimitive( name ) ;
        if( o != null ) {
            if( o instanceof java.util.Date ) {
                return ( java.util.Date )o ;
            }
            Date ret = null ;
            try {
                if( locale == null ) {
                    locale = Locale.US ;
                }
                ret = new SimpleDateFormat( format,locale ).parse( ( String )o ) ;
            } catch( Exception e ) {
                ret = null ;
            }
            return ret ;
        }
        return null ;
    }
    
    /**
     * Date情報を設定.
     * <BR><BR>
     * Date情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param format フォーマット情報を設定します.
     * @param locale 対象のロケールを設定します.
     * @param value 情報を設定します.
     */
    public void setDate( String name,String format,Locale locale,Date value ) {
        if( name == null || value == null ||
            format == null || format.length() <= 0 ||
            ( name = name.trim() ).length() <= 0 ) {
            return ;
        }
        try {
            if( locale == null ) {
                locale = Locale.US ;
            }
            String val = new SimpleDateFormat( format,locale ).format( value ) ;
            if( val != null && val.length() > 0 ) {
                set( name,val ) ;
            }
        } catch( Exception e ) {
        }
    }
    
    /**
     * List情報を取得.
     * <BR><BR>
     * List情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return List 情報が返されます.
     */
    public List getList( String name ) {
        return ( List )getByList( name ) ;
    }
    
    /**
     * List情報を設定.
     * <BR><BR>
     * List情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 情報を設定します.
     */
    public void setList( String name,List value ) {
        if( name == null || value == null || ( name = name.trim() ).length() <= 0 ) {
            return ;
        }
        set( name,value ) ;
    }
    
    /**
     * HttpBinary情報を取得.
     * <BR><BR>
     * HttpBinary情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return HttpBinary 情報が返されます.
     */
    public HttpBinary getHttpBinary( String name ) {
        return ( HttpBinary )getByHttpBinary( name ) ;
    }
    
    /**
     * Object情報を取得.
     * <BR><BR>
     * Object情報を取得します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @return Object 情報が返されます.
     */
    public Object getObject( String name ) {
        return get( name ) ;
    }
    
    /**
     * 指定Bean情報からパラメータ群を取得.
     * <BR><BR>
     * 指定Bean情報からパラメータ群を取得します.
     * <BR>
     * @param cls 対象のBeanクラスを設定します.
     * @return Object 対象の情報が返されます.
     * @exception Exception 例外.
     */
    public Object getBean( Class cls ) throws Exception {
        if( cls == null ) {
            return null ;
        }
        Object o = Reflect.newObject( cls ) ;
        getBean( o ) ;
        return o ;
    }
    
    /**
     * 指定Bean情報からパラメータ群を取得.
     * <BR><BR>
     * 指定Bean情報からパラメータ群を取得します.
     * <BR>
     * @param object 対象のBeanオブジェクトを設定します.
     * @exception Exception 例外.
     */
    public void getBean( Object object ) throws Exception {
        ArrayList<Method> mds = Reflect.getMethodObjectList( object ) ;
        if( mds != null && mds.size() > 0 ) {
            int len = mds.size() ;
            for( int i = 0 ; i < len ; i ++ ) {
                Method md = ( Method )mds.get( i ) ;
                String name = md.getName() ;
                if( name.startsWith( "set" ) ) {
                    Class[] params = md.getParameterTypes() ;
                    if( params != null && params.length == 1 ) {
                        String key = name.substring( "set".length(),name.length() ) ;
                        key = key.substring( 0,1 ).toLowerCase() + key.substring( 1,key.length() ) ;
                        Object val = this.getObject( key ) ;
                        if( val != null ) {
                            Class paramClass = params[ 0 ] ;
                            if( Reflect.equalsClass( paramClass,val.getClass() ) ) {
                                Reflect.executionMethod( name,object,val ) ;
                            }
                            else {
                                if( paramClass.equals( Boolean.class ) ) {
                                    Object cnv = getBoolean( key ) ;
                                    if( cnv != null ) {
                                        Reflect.executionMethod( name,object,cnv ) ;
                                    }
                                }
                                else if( paramClass.equals( Integer.class ) ) {
                                    Object cnv = getInteger( key ) ;
                                    if( cnv != null ) {
                                        Reflect.executionMethod( name,object,cnv ) ;
                                    }
                                }
                                else if( paramClass.equals( Long.class ) ) {
                                    Object cnv = getLong( key ) ;
                                    if( cnv != null ) {
                                        Reflect.executionMethod( name,object,cnv ) ;
                                    }
                                }
                                else if( paramClass.equals( Float.class ) ) {
                                    Object cnv = getFloat( key ) ;
                                    if( cnv != null ) {
                                        Reflect.executionMethod( name,object,cnv ) ;
                                    }
                                }
                                else if( paramClass.equals( Double.class ) ) {
                                    Object cnv = getDouble( key ) ;
                                    if( cnv != null ) {
                                        Reflect.executionMethod( name,object,cnv ) ;
                                    }
                                }
                                else if( paramClass.equals( java.util.Date.class ) ||
                                    paramClass.equals( java.sql.Date.class ) ||
                                    paramClass.equals( java.sql.Time.class ) ||
                                    paramClass.equals( java.sql.Timestamp.class ) ) {
                                    Object cnv = convertDateUs( getString( key ) ) ;
                                    if( cnv != null ) {
                                        Reflect.executionMethod( name,object,cnv ) ;
                                    }
                                }
                                else if( paramClass.equals( byte[].class ) ) {
                                    Object cnv = null ;
                                    if( val instanceof HttpBinary ) {
                                        cnv = getHttpBinary( key ).getBinary() ;
                                    }
                                    else if( val instanceof byte[] ) {
                                        cnv = ( byte[] )getObject( key ) ;
                                    }
                                    else if( val instanceof List ) {
                                        cnv = getList( key ) ;
                                        if( ( ( List )cnv ).size() > 0 ) {
                                            if( ( ( List )cnv ).get( 0 ) instanceof HttpBinary ) {
                                                cnv = ( ( HttpBinary )( ( List )cnv ).get( 0 ) ).getBinary() ;
                                            }
                                            else if( ( ( List )cnv ).get( 0 ) instanceof byte[] ) {
                                                cnv = ( byte[] )( ( List )cnv ).get( 0 ) ;
                                            }
                                        }
                                    }
                                    if( cnv != null ) {
                                        Reflect.executionMethod( name,object,cnv ) ;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    /**
     * 指定Bean情報をパラメータ群に設定.
     * <BR><BR>
     * 指定Bean情報をパラメータ群に設定します.
     * <BR>
     * @param object 設定対象のオブジェクトを設定します.
     * @exception Exception 例外.
     */
    public void setBean( Object object ) throws Exception {
        if( object == null ) {
            return ;
        }
        ArrayList<Method> mds = Reflect.getMethodObjectList( object ) ;
        if( mds != null && mds.size() > 0 ) {
            int len = mds.size() ;
            for( int i = 0 ; i < len ; i ++ ) {
                Method md = mds.get( i ) ;
                String name = md.getName() ;
                if( ( name.startsWith( "get" ) || name.startsWith( "is" ) ) &&
                    ( md.getParameterTypes() == null || md.getParameterTypes().length <= 0 ) ) {
                    String paramName = null ;
                    if( name.startsWith( "get" ) ) {
                        paramName = name.substring( "get".length(),name.length() ).trim() ;
                    }
                    else {
                        paramName = name.substring( "is".length(),name.length() ).trim() ;
                    }
                    if( paramName.length() > 0 ) {
                        paramName = paramName.substring( 0,1 ).toLowerCase() + paramName.substring( 1,paramName.length() ) ;
                        if( updateManager.get( paramName ) == null ) {
                            Object val = null ;
                            try {
                                val = Reflect.executionMethod( name,object ) ;
                            } catch( Exception e ) {
                                val = null ;
                            }
                            if( val != null ) {
                                try {
                                    setAbstract( paramName,val ) ;
                                } catch( Exception ee ) {
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    /**
     * 更新内容のキー名を取得.
     * <BR><BR>
     * 更新内容のキー名を取得します.
     * <BR>
     * @return Object[] 更新内容キーが返されます.
     */
    public Object[] getUpdateKeys() {
        return updateManager.keySet().toArray() ;
    }
    
    private Object get( String name ) {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            return null ;
        }
        Object ret = null ;
        try {
            ret = getAbstract( name ) ;
        } catch( Exception e ) {
            ret = null ;
        }
        return ret ;
    }
    private void set( String name,Object value ) {
        if( name == null || ( name = name.trim() ).length() <= 0 || value == null ) {
            return ;
        }
        try {
            setAbstract( name,value ) ;
            updateManager.put( name,new Long( System.currentTimeMillis() ) ) ;
        } catch( Exception e ) {
        }
    }
    private Object getByPrimitive( String name ) {
        Object o = get( name ) ;
        if( o == null || ( o instanceof HttpBinary ) || ( o instanceof List ) ) {
            if( o instanceof List && ( ( List )o ).size() > 0 ) {
                return ( String )( ( ArrayList )o ).get( 0 ) ;
            }
            return null ;
        }
        return o ;
    }
    private Object getByList( String name ) {
        Object o = get( name ) ;
        if( o != null && ( o instanceof List ) ) {
            return o ;
        }
        return null ;
    }
    private Object getByHttpBinary( String name ) {
        Object o = get( name ) ;
        if( o != null && ( o instanceof HttpBinary ) ) {
            return o ;
        }
        return null ;
    }
    
    /**
     * 基本日付フォーマット.
     */
    private static final String[] DEFAULT_DATE_FORMAT = {
        "EEE, d MMM yyyy HH:mm:ss Z",
        "yyyy/MM/dd HH:mm:ss",
        "yyyy/MM/dd HH:mm",
        "yyyy/MM/dd-HH:mm:ss",
        "yyyy/MM/dd-HH:mm",
        "yyyy-MM-dd HH:mm:ss",
        "yyyy-MM-dd HH:mm",
        "yyyy-MM-dd-HH:mm:ss",
        "yyyy-MM-dd-HH:mm",
    } ;
    
    /**
     * 基本日付フォーマット(日本語).
     */
    private static final String[] DEFAULT_DATE_FORMAT_JP = {
        "yyyy年MM月dd日 HH時mm分ss秒",
        "yyyy年MM月dd日 HH時mm分",
        "yyyy年MM月dd日-HH時mm分ss秒",
        "yyyy年MM月dd日-HH時mm分"
    } ;
    
    /**
     * 日付フォーマット.
     */
    private static final String[] DATE_FORMAT = {
        "EEE, MMM d, ''yy",
        "yyyy/MM/dd",
        "yyyy-MM-dd"
    } ;
    
    /**
     * 日付フォーマット(日本語).
     */
    private static final String[] DATE_FORMAT_JP = {
        "yyyy年MM月dd日"
    } ;
    
    /**
     * 時間フォーマット.
     */
    private static final String[] TIME_FORMAT = {
        "HH:mm:ss",
        "HH:mm",
        "h:mm a"
    } ;
    
    /**
     * 時間フォーマット(日本語).
     */
    private static final String[] TIME_FORMAT_JP = {
        "HH時mm分ss秒",
        "HH時mm分",
        "h時mm分 a"
    } ;
    
    private static final Date convertDateUs( String date ) {
        if( date == null || ( date = date.trim() ).length() <= 0 ) {
            return null ;
        }
        Date ret = null ;
        if( ( ret = convertDateByFormatArray( DEFAULT_DATE_FORMAT,Locale.US,date ) ) != null ) {
            return ret ;
        }
        if( ( ret = convertDateByFormatArray( DEFAULT_DATE_FORMAT_JP,Locale.JAPAN,date ) ) != null ) {
            return ret ;
        }
        if( ( ret = convertDateByFormatArray( DATE_FORMAT,Locale.US,date ) ) != null ) {
            return ret ;
        }
        if( ( ret = convertDateByFormatArray( DATE_FORMAT_JP,Locale.JAPAN,date ) ) != null ) {
            return ret ;
        }
        if( ( ret = convertDateByFormatArray( TIME_FORMAT,Locale.US,date ) ) != null ) {
            return ret ;
        }
        if( ( ret = convertDateByFormatArray( TIME_FORMAT_JP,Locale.JAPAN,date ) ) != null ) {
            return ret ;
        }
        return null ;
    }
    
    private static final Date convertDateByFormatArray( String[] formats,Locale locale,String date ) {
        Date ret = null ;
        int len = formats.length ;
        for( int i = 0 ; i < len ; i ++ ) {
            if( ( ret = convertDateByFormat( formats[ i ],locale,date ) ) != null ) {
                return ret ;
            }
        }
        return null ;
    }
    
    private static final Date convertDateByFormat( String format,Locale locale,String date ) {
        try {
            return new SimpleDateFormat( format,locale ).parse( date ) ;
        } catch( Exception e ) {
        }
        return null ;
    }
    
}
