package org.maachang.dao.dbms.kind;

/**
 * 種類管理.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class KindManager {
    
    private static final SupportKind[] KINDS = {
        new KindByPostgre(),
        new KindByMySql(),
        new KindByFireBird(),
        new KindByDerby(),
        new KindByH2(),
        new KindByHSql()
    } ;
    
    public static final SupportKind get( String adapter ) {
        if( adapter == null || ( adapter = adapter.trim().toLowerCase() ).length() <= 0 ) {
            return null ;
        }
        int len = KINDS.length ;
        for( int i = 0 ; i < len ; i ++ ) {
            if( adapter.equals( KINDS[ i ].getAdapter() ) ) {
                return KINDS[ i ] ;
            }
        }
        return null ;
    }
    
    
}
