package org.maachang.dao.dbms.kind;

/**
 * MySQL用DBMS定義.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class KindByMySql extends SupportKind {
    
    /**
     * Boolean非サポートフラグ.
     * <BR><BR>
     * Boolean非サポートフラグを取得します.
     * <BR>
     * @return boolean [true]の場合は、サポートしています.
     */
    public boolean isBoolean() {
        return true ;
    }
    
    /**
     * アダプタ名を取得.
     * <BR><BR>
     * アダプタ名を取得します.
     * <BR>
     * @return String アダプタ名が返されます.
     */
    public String getAdapter() {
        return "mysql" ;
    }
    
    /**
     * IDを設定した後の取得SQL.
     * <BR><BR>
     * IDを設定した後の取得SQLが返されます.
     * <BR>
     * @return String SQLが返されます.
     */
    public String getInsertIdBySQL() {
        return "SELECT LAST_INSERT_ID()";
    }
    
}
