package org.maachang.dao.dbms.ctbl;

/**
 * テーブル支援ユーティリティ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
class TableUtil {
    
    /**
     * 対象カラムタイプの文字列を取得.
     * <BR><BR>
     * 対象カラムタイプの文字列を取得します.
     * <BR>
     * @param table 処理対象のテーブルオブジェクトを設定します.
     * @param type 対象の処理タイプを設定します.
     * @return カラムタイプが返されます.
     */
    public static final String getColumnName( Table table,String type ) {
        if( type == null || ( type = type.trim() ).length() <= 0 ) {
            return null ;
        }
        type = type.toLowerCase() ;
        if( Table.BOOLEAN.equals( type ) ) {
            return table.typeByBoolean() ;
        }
        else if( Table.INTEGER.equals( type ) ) {
            return table.typeByInt() ;
        }
        else if( Table.LONG.equals( type ) ) {
            return table.typeByLong() ;
        }
        else if( Table.FLOAT.equals( type ) ) {
            return table.typeByFloat() ;
        }
        else if( Table.DOUBLE.equals( type ) ) {
            return table.typeByDouble() ;
        }
        else if( Table.BINARY.equals( type ) ) {
            return table.typeByBytes() ;
        }
        else if( Table.CHAR.equals( type ) ) {
            return table.typeByChar() ;
        }
        else if( Table.TEXT.equals( type ) ) {
            return table.typeByText() ;
        }
        else if( Table.DATE.equals( type ) ) {
            return table.typeByDate() ;
        }
        else if( Table.TIME.equals( type ) ) {
            return table.typeByTime() ;
        }
        else if( Table.TIMESTAMP.equals( type ) ) {
            return table.typeByTimestamp() ;
        }
        return null ;
    }
    
    /**
     * カラム要素の文字列を取得.
     * <BR><BR>
     * カラム要素の文字列を取得します.
     * <BR>
     * @param mode 処理結果で戻されるモードが返されます.
     * @param table 処理対象のテーブルオブジェクトを設定します.
     * @param type 対象の処理タイプを設定します.
     * @return String 対象のカラムタイプが返されます.
     */
    public static final String getColumnType( int[] mode,Table table,String type ) {
        if( type == null || ( type = type.trim() ).length() <= 0 ) {
            return null ;
        }
        String t = type.toLowerCase() ;
        if( Table.COLUMN_NOT_NULL.equals( t ) ) {
            mode[ 0 ] = 1 ;
            return table.notNullName() ;
        }
        if( Table.COLUMN_NOT_NULL2.equals( t ) ) {
            mode[ 0 ] = 1 ;
            return table.notNullName() ;
        }
        else if( Table.COLUMN_UNIQUE.equals( t ) ) {
            mode[ 0 ] = 2 ;
            return table.uniqueName() ;
        }
        else if( t.startsWith( Table.COLUMN_DEFAULT ) ) {
            mode[ 0 ] = 3 ;
            String val = type.substring( Table.COLUMN_DEFAULT.length(),type.length() ).trim() ;
            if( val.startsWith( "\"" ) && val.endsWith( "\"" ) ) {
                val = val.substring( 1,val.length()-1 ) ;
            }
            else if( val.startsWith( "\'" ) && val.endsWith( "\'" ) ) {
                val = val.substring( 1,val.length()-1 ) ;
            }
            return new StringBuilder().append( table.defaultName() ).
                append( " " ).append( "\'" ).append( val ).append( "\'" ).
                toString() ;
        }
        return null ;
    }
    
    /**
     * 指定条件がindexであるかチェック.
     * <BR><BR>
     * 指定条件がindexであるかチェックします.
     * <BR>
     * @param type 対象の処理タイプを設定します.
     * @return boolean [true]の場合、インデックスです.
     */
    public static final boolean isIndex( String type ) {
        if( type == null || ( type = type.trim() ).length() <= 0 ) {
            return false ;
        }
        type = type.toLowerCase() ;
        if( Table.COLUMN_INDEX.equals( type ) ) {
            return true ;
        }
        return false ;
    }
    
    /**
     * 指定条件がkeyであるかチェック.
     * <BR><BR>
     * 指定条件がkeyであるかチェックします.
     * <BR>
     * @param type 対象の処理タイプを設定します.
     * @return boolean [true]の場合、キーです.
     */
    public static final boolean isKey( String type ) {
        if( type == null || ( type = type.trim() ).length() <= 0 ) {
            return false ;
        }
        type = type.toLowerCase() ;
        if( Table.COLUMN_KEY.equals( type ) ) {
            return true ;
        }
        return false ;
    }
    
    /**
     * 指定条件がtypeであるかチェック.
     * <BR><BR>
     * 指定条件がtypeであるかチェックします.
     * <BR>
     * @param key 対象の処理タイプを設定します.
     * @return boolean [true]の場合、タイプです.
     */
    public static final boolean isType( String key ) {
        if( key == null || ( key = key.trim() ).length() <= 0 ) {
            return false ;
        }
        key = key.toLowerCase() ;
        if( Table.TABLE_TYPE.equals( key ) ) {
            return true ;
        }
        return false ;
    }
}
