package org.maachang.dao.dbms.ctbl;

import java.util.HashSet;

import org.maachang.dao.dbms.kind.SupportKind;
import org.maachang.engine.conf.Config;
import org.maachang.engine.util.StringUtil;

/**
 * テーブル定義(FireBird).
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class TableFireBird implements Table {
    
    /**
     * アダプタ名を取得.
     * <BR><BR>
     * アダプタ名を取得します.
     * <BR>
     * @return String アダプタ名が返されます.
     */
    public String getAdapter() {
        return "firebirdsql" ;
    }
    
    /**
     * 指定パラメータから、CreateTable条件を生成.
     * <BR><BR>
     * 指定パラメータから、CreateTable条件を生成します.
     * <BR>
     * @param params 対象のパラメータを設定します.
     * @return String 生成されたCreateTableが返されます.
     */
    public String createTable( Config params ) {
        StringBuilder buf = new StringBuilder() ;
        Object[] sections = params.getSections() ;
        if( sections != null && sections.length > 0 ) {
            int len = sections.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( sections[ i ] != null ) {
                    createOneSection( buf,( String )sections[ i ],params ) ;
                }
            }
            return buf.toString() ;
        }
        return null ;
    }
    
    /**
     * boolean型を取得.
     * <BR><BR>
     * boolean型を取得します.
     * <BR>
     * @return String boolean型の文字列が返されます.
     */
    public String typeByBoolean() {
        return "CHAR(1)" ;
    }
    
    /**
     * intの条件を取得.
     * <BR><BR>
     * intの条件を取得します.
     * <BR>
     * @return String int型の文字列が返されます.
     */
    public String typeByInt() {
        return "INTEGER" ;
    }
    
    /**
     * longの条件を取得.
     * <BR><BR>
     * longの条件を取得します.
     * <BR>
     * @return String long型の文字列が返されます.
     */
    public String typeByLong() {
        return "BIGINT" ;
    }
    
    /**
     * floatの条件を取得.
     * <BR><BR>
     * floatの条件を取得します.
     * <BR>
     * @return String float型の文字列が返されます.
     */
    public String typeByFloat() {
        return "FLOAT" ;
    }
    
    /**
     * doubleの条件を取得.
     * <BR><BR>
     * doubleの条件を取得します.
     * <BR>
     * @return String double型の文字列が返されます.
     */
    public String typeByDouble() {
        return "DOUBLE PRECISION" ;
    }
    
    /**
     * byte配列の条件を取得.
     * <BR><BR>
     * byte配列の条件を取得します.
     * <BR>
     * @return String byte配列型の文字列が返されます.
     */
    public String typeByBytes() {
        return "BLOB SUB_TYPE 0" ;
    }
    
    /**
     * char条件を取得.
     * <BR><BR>
     * char条件を取得します.
     * <BR>
     * @return String char型の文字列が返されます.
     */
    public String typeByChar() {
        return "VARCHAR(255)" ;
    }
    
    /**
     * text条件を取得.
     * <BR><BR>
     * text条件を取得します.
     * <BR>
     * @return String text型の文字列が返されます.
     */
    public String typeByText() {
        return "VARCHAR(32767)" ;
    }
    
    /**
     * date条件を取得.
     * <BR><BR>
     * date条件を取得します.
     * <BR>
     * @return String date型の文字列が返されます.
     */
    public String typeByDate() {
        return "DATE" ;
    }
    
    /**
     * time条件を取得.
     * <BR><BR>
     * time条件を取得します.
     * <BR>
     * @return String time型の文字列が返されます.
     */
    public String typeByTime() {
        return "TIME" ;
    }
    
    /**
     * timestamp条件を取得.
     * <BR><BR>
     * timestamp条件を取得します.
     * <BR>
     * @return String timestamp型の文字列が返されます.
     */
    public String typeByTimestamp() {
        return "TIMESTAMP" ;
    }
    
    /**
     * プライマリーキー条件を取得.
     * <BR><BR>
     * プライマリーキー条件を取得します.
     * <BR>
     * @return String プライマリーキー条件の文字列が返されます.
     */
    public String primaryKeyName() {
        return "PRIMARY KEY" ;
    }
    
    /*
     * インデックス条件を取得.
     * <BR><BR>
     * インデックス条件を取得します.
     * <BR>
     * @return String インデックス条件の文字列が返されます.
     */
    public String indexName() {
        return null ;
    }
    
    /**
     * not_null条件を取得.
     * <BR><BR>
     * not_null条件を取得します.
     * <BR>
     * @return String not_null条件の文字列が返されます.
     */
    public String notNullName() {
        return "NOT NULL" ;
    }
    
    /**
     * unique条件を取得.
     * <BR><BR>
     * unique条件を取得します.
     * <BR>
     * @return String unique条件の文字列が返されます.
     */
    public String uniqueName() {
        return "UNIQUE" ;
    }
    
    /**
     * default条件を取得.
     * <BR><BR>
     * default条件を取得します.
     * <BR>
     * @return Stirng default条件の文字列が返されます.
     */
    public String defaultName() {
        return "DEFAULT" ;
    }
    
    /**
     * 対象１セクションからテーブルを構成.
     */
    private void createOneSection( StringBuilder buf,String section,Config params ) {
        if( section == null ) {
            return ;
        }
        Object[] keys = params.getKeys( section ) ;
        if( keys != null && keys.length > 0 ) {
            int len = keys.length ;
            HashSet<String> primaryKey = new HashSet<String>() ;
            buf.append( "drop table " ).append( section ).append( "; \n" ) ;
            buf.append( "create table " ).append( section ).append( "(" ) ;
            // id.
            buf.append( "id BIGINT NOT NULL UNIQUE" ) ;
            boolean next = true ;
            // 定義されている各カラム条件.
            for( int i = 0 ; i < len ; i ++ ) {
                if( next == true ) {
                    buf.append( "," ) ;
                    next = false ;
                }
                String key = ( String )keys[ i ] ;
                String type = null ;
                String not_null = null ;
                String unique = null ;
                String def = null ;
                String[] one = params.getAll( section,key ) ;
                int lenJ = one.length ;
                int[] mode = new int[ 1 ] ;
                
                if( "id".equals( key.toLowerCase() ) ) {
                    continue ;
                }
                // テーブルタイプが定義されている場合.
                if( TableUtil.isType( key ) == true ) {
                    continue ;
                }
                // カラム定義.
                else {
                    for( int j = 0 ; j < lenJ ; j ++ ) {
                        String tmp = null ;
                        tmp = TableUtil.getColumnName( this,one[ j ] ) ;
                        if( tmp != null ) {
                            type = tmp ;
                            continue ;
                        }
                        tmp = TableUtil.getColumnType( mode,this,one[ j ] ) ;
                        if( tmp != null ) {
                            switch( mode[ 0 ] ) {
                                case 1 : not_null = tmp ; break ;
                                case 2 : unique = tmp ; break ;
                                case 3 :
                                    if( typeByBoolean().equals( type ) ) {
                                        String data = tmp.substring( "default".length(),tmp.length() ).trim() ;
                                        data = StringUtil.catCote( data ).toLowerCase() ;
                                        if( "true".equals( data ) ) {
                                            data = ( String )getBooleanByTrue() ;
                                        }
                                        else {
                                            data = ( String )getBooleanByFalse() ;
                                        }
                                        tmp = defaultName()+" \'"+data+"\'" ;
                                    }
                                    else if( typeByBytes().equals( type ) == false ) {
                                        def = tmp ;
                                    }
                                    break ;
                            }
                            continue ;
                        }
                        if( TableUtil.isIndex( one[ j ] ) == true ) {
                            // derbyでは、indexは、プライマリーキーとする.
                            primaryKey.add( key.toLowerCase() ) ;
                            not_null = notNullName() ;
                        }
                        if( TableUtil.isKey( one[ j ] ) == true ) {
                            primaryKey.add( key.toLowerCase() ) ;
                            not_null = notNullName() ;
                        }
                    }
                    if( type == null ) {
                        continue ;
                    }
                    buf.append( key.toLowerCase() ).
                        append( " " ).
                        append( type ) ;
                    if( unique != null ) {
                        buf.append( " " ).append( unique ) ;
                    }
                    if( not_null != null ) {
                        buf.append( " " ).append( not_null ) ;
                    }
                    if( def != null ) {
                        buf.append( " " ).append( def ) ;
                    }
                    next = true ;
                }
            }
            
            if( buf.toString().endsWith( "," ) == false ) {
                buf.append( "," ) ;
            }
            if( primaryKey.size() > 0 ) {
                buf.append( primaryKeyName() ).append( "(" ) ;
                buf.append( "id" ) ;
                Object[] vals = primaryKey.toArray() ;
                int lenI = vals.length ;
                for( int i = 0 ; i < lenI ; i ++ ) {
                    buf.append( "," ).append( vals[ i ] ) ;
                }
                buf.append( ")" ) ;
            }
            else {
                buf.append( primaryKeyName() ) ;
                buf.append( "(id)" ) ;
            }
            buf.append( ")" ) ;
            buf.append( " ; \n" ) ;
            // firebirdでは、シーケンスIDを設定.
            buf.append( "drop sequence " ).append( section.toLowerCase() ).
                append( SupportKind.SEQ_NAME ).append( "; \n" ) ;
            buf.append( "create sequence " ).append( section.toLowerCase() ).
                append( SupportKind.SEQ_NAME ).append( "; \n" ) ;
        }
    }
    
    /**
     * BOOLEAN型の型変換情報.
     * <BR><BR>
     * BOOLEAN型での型変換情報を取得します.
     * <BR>
     * @param src 変換元の情報を設定します.
     * @return Object Boolean型となる型情報が返されます.
     */
    public Object getBooleanType( Boolean src ) {
        if( src == null ) {
            return null ;
        }
        boolean srcBoolean = src.booleanValue() ;
        if( srcBoolean == true ) {
            return getBooleanByTrue() ;
        }
        else {
            return getBooleanByFalse() ;
        }
    }
    
    /**
     * BOOLEAN型[true]情報.
     * <BR><BR>
     * BOOLEAN型の[true]情報が返されます.
     * <BR>
     * @return Object Boolean型の[true]条件が返されます.
     */
    public Object getBooleanByTrue() {
        return "1" ;
    }
    
    /**
     * BOOLEAN型[false]情報.
     * <BR><BR>
     * BOOLEAN型の[false]情報が返されます.
     * <BR>
     * @return Object Boolean型の[false]条件が返されます.
     */
    public Object getBooleanByFalse() {
        return "0" ;
    }
}
