package org.maachang.dao.dbms.ctbl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StringReader;

import org.maachang.dao.dbms.DbmsInfo;
import org.maachang.dao.dbms.Record;
import org.maachang.dao.dbms.RecordFactory;
import org.maachang.dao.dbms.kind.SupportKind;
import org.maachang.engine.conf.Config;
import org.maachang.engine.conf.ReadIni;
import org.maachang.engine.util.FileUtil;

/**
 * テーブル生成オブジェクト.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class CreateTable {
    
    /**
     * コンストラクタ.
     */
    private CreateTable() {
        
    }
    
    /**
     * メインメソッド.
     * <BR><BR>
     * @param args Javaからのパラメータが設定されます.
     * @exception Exception 例外.
     */
    public static final void main( String[] args )
        throws Exception {
        if( args == null || args.length <= 0 ) {
            System.out.println( "DBMSコンフィグファイルを設定してください" ) ;
            return ;
        }
        new CreateTable().execution( args ) ;
    }
    
    /**
     * 実行処理.
     */
    private void execution( String[] args )
        throws Exception {
        System.out.println( "## startup create table" ) ;
        long tm = System.currentTimeMillis() ;
        BufferedReader buf = null ;
        Record record = null ;
        args = convertToLowerCase( args ) ;
        if( args != null && args.length > 0 ) {
            System.out.println( "実行mask テーブル名." ) ;
            int len = args.length ;
            int cnt = 0 ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( args[ i ] != null ) {
                    System.out.println( " = [" + ( cnt+1 ) + "]:"+args[ i ] ) ;
                    cnt ++ ;
                }
            }
            System.out.println( "合計:" + cnt ) ;
            System.out.println() ;
        }
        try {
            Config conf = DbmsInfo.getConfig( args[ 0 ] ) ;
            if( conf.get( "createTable","define_directory",0 ) == null ||
                conf.get( "createTable","define_package",0 ) == null ||
                conf.get( "createTable","output_entry_java",0 ) == null ) {
                System.out.println( "必須条件のコンフィグ内容が設定されていません" ) ;
            }
            String basePath = conf.get( "createTable","define_directory",0 ) ;
            Config tableConfig = readTableConfig( conf,basePath,args ) ;
            if( tableConfig == null ) {
                System.out.println( "読み込み可能なコンフィグファイルは存在しません." ) ;
                return ;
            }
            System.out.println() ;
            RecordFactory factory = DbmsInfo.getRecordFactory( conf ) ;
            if( factory == null ) {
                System.out.println( "データベース定義は存在しません." ) ;
                return ;
            }
            System.out.println() ;
            SupportKind dbms = factory.getSupportKind() ;
            if( dbms == null ) {
                System.out.println( "アダプタ名が非サポートデータベースです." ) ;
                return ;
            }
            Table table = TableMaster.get( dbms.getAdapter() ) ;
            String string = table.createTable( tableConfig ) ;
            if( string == null || ( string = string.trim() ).length() <= 0 ) {
                return ;
            }
            // SQL内容を出力.
            FileUtil.setFileByString( "./createTable.sql",true,string,"UTF8" ) ;
            
            buf = new BufferedReader( new StringReader( string ) ) ;
            string = null ;
            record = factory.getRecord() ;
            record.getConnection().setAutoCommit( true ) ;
            
            // Entry情報を出力.
            if( getFlag( conf.get( "createTable","entry_out",0 ) ) == true ) {
                ConfigByOutputEntry entry = new ConfigByOutputEntry(
                    conf.get( "createTable","define_package",0 ),
                    conf.get( "createTable","output_entry_java",0 ) ) ;
                entry.output( tableConfig ) ;
                entry = null ;
            }
            
            for( ;; ) {
                String one = buf.readLine() ;
                if( one == null ) {
                    break ;
                }
                System.out.println( ">"+one ) ;
                try {
                    record.executeUpdate( one ) ;
                    try {
                        record.commit() ;
                    } catch( Exception ee ) {
                        try {
                            record.rollback() ;
                        } catch( Exception eee ) {
                        }
                    }
                    System.out.println( ".....OK." ) ;
                } catch( Exception e ) {
                    if( one.trim().toLowerCase().startsWith( "create " ) ) {
                        try {
                            record.rollback() ;
                        } catch( Exception ee ) {
                        }
                        throw e ;
                    }
                    System.out.println( ".....>>"+e ) ;
                }
                System.out.println() ;
            }
            try {
                record.commit() ;
            } catch( Exception ee ) {
                try {
                    record.rollback() ;
                } catch( Exception eee ) {
                }
            }
            System.out.println( "## success:" + (System.currentTimeMillis()-tm)+"ms" ) ;
        } catch( Exception e ) {
            try {
                record.rollback() ;
            } catch( Exception ee ) {
            }
            System.out.println( "## error" ) ;
            e.printStackTrace() ;
        } finally {
            try {
                buf.close() ;
            } catch( Exception e ) {
            }
        }
    }
    
    /**
     * tableディレクトリ以下の定義ファイルを読み込む.
     */
    private Config readTableConfig( Config config,String path,String[] args )
        throws Exception {
        Config ret = null ;
        int cnt = 0 ;
        int chkLen = 0 ;
        if( args != null && args.length > 0 ) {
            chkLen = args.length ;
        }
        String readPath = path ;
        readPath = FileUtil.getFullPath( readPath )+FileUtil.FILE_SPACE ;
        String[] data = FileUtil.getFileList( readPath ) ;
        if( data != null ) {
            int len = data.length ;
            System.out.println( "@@@@ read config [START]" ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( data[ i ] == null || ( data[ i ] = data[ i ].trim() ).length() <= 0 ) {
                    continue ;
                }
                boolean chkFlag = false ;
                if( chkLen <= 1 ) {
                    chkFlag = true ;
                }
                else {
                    String chk = data[ i ].toLowerCase() ;
                    for( int j = 1 ; j < chkLen ; j ++ ) {
                        if( chk.startsWith( args[ j ] ) ) {
                            chkFlag = true ;
                            break ;
                        }
                    }
                }
                if( chkFlag == true && data[ i ].endsWith( ".conf" ) ) {
                    System.out.println( "-- readFile:" + data[ i ] ) ;
                    if( ret == null ) {
                        ret = new Config() ;
                    }
                    getIniParams( ret,readPath+data[ i ] ) ;
                    cnt ++ ;
                }
            }
            System.out.println( "@@@@ read config [END:" + cnt + "]" ) ;
        }
        return ret ;
    }
    
    /**
     * 対象パラメータの文字コードを小文字変換.
     */
    private String[] convertToLowerCase( String[] args ) {
        if( args == null || args.length <= 0 ) {
            return null ;
        }
        int len = args.length ;
        for( int i = 1 ; i < len ; i ++ ) {
            if( args[ i ] == null || ( args[ i ] = args[ i ].trim() ).length() <= 0 ) {
                args[ i ] = null ;
            }
            args[ i ] = args[ i ].toLowerCase() ;
        }
        return args ;
    }
    
    /**
     * Configファイルを取得.
     */
    private void getIniParams( Config out,String name )
        throws Exception {
        BufferedReader buf = null ;
        try {
            buf = new BufferedReader( new InputStreamReader( new FileInputStream( name ),"UTF8" ) ) ;
            ReadIni.analisys( out,buf ) ;
            buf.close() ;
            buf = null ;
        } finally {
            if( buf != null ) {
                try {
                    buf.close() ;
                } catch( Exception e ) {
                }
            }
            buf = null ;
        }
    }
    
    /**
     * Entry出力フラグを変換.
     */
    private static final boolean getFlag( String value ) {
        boolean ret = false ;
        try {
            value = value.trim().toLowerCase() ;
            if( value.equals( "true" ) ) {
                ret = true ;
            }
        } catch( Exception e ) {
            ret = false ;
        }
        return ret ;
    }
}
