package org.maachang.dao.dbms.ctbl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import org.maachang.dao.dbms.DbUtil;
import org.maachang.engine.util.FileUtil;
import org.maachang.engine.util.StringUtil;

/**
 * １つのエントリー生成.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class CreateEntry {
    
    private String packageName = null ;
    private String modelName = null ;
    private ArrayList<OneEntry> params = null ;
    
    private CreateEntry() {
        
    }
    
    public CreateEntry( String packageName,String modelName ) {
        this.packageName = packageName ;
        this.modelName = DbUtil.convertJavaNameByDBName( modelName ) ;
        this.params = new ArrayList<OneEntry>() ;
    }
    
    public static final int getFieldType( String fieldType ) {
        return OneEntry.getFieldType( fieldType ) ;
    }
    
    public void add( String name,String fieldType ) {
        if( OneEntry.getFieldType( fieldType ) != -1 ) {
            OneEntry entry = new OneEntry( name,fieldType ) ;
            this.params.add( entry ) ;
        }
    }
    
    public void getEntryFileOut( String baseDir )
        throws Exception {
        String output = getDir( false,baseDir ) ;
        String dir = output.substring( 0,output.length() - FileUtil.getFileName( output ).length() ) ;
        if( FileUtil.isDirExists( dir ) == false ) {
            FileUtil.mkdirs( dir ) ;
        }
        String out = getMethodFile() ;
        FileUtil.setFileByString( output,true,out,"UTF8" ) ;
    }
    
    public void getDaoFileOut( String baseDir )
        throws Exception {
        String output = getDir( true,baseDir ) ;
        String dir = output.substring( 0,output.length() - FileUtil.getFileName( output ).length() ) ;
        if( FileUtil.isDirExists( dir ) == false ) {
            FileUtil.mkdirs( dir ) ;
        }
        String out = getDaoFile() ;
        FileUtil.setFileByString( output,true,out,"UTF8" ) ;
    }
    
    public String getPackageName() {
        return packageName ;
    }
    
    public String getModelName() {
        return modelName ;
    }
    
    public int getParamsSize() {
        return params.size() ;
    }
    
    public String getDir( boolean mode,String baseDir )
        throws Exception {
        String javaModelName = DbUtil.convertDBNameByJavaName( true,modelName ) ;
        if( baseDir.endsWith( "\\" ) == false && baseDir.endsWith( "/" ) == false ) {
            baseDir += "/" ;
        }
        String x = StringUtil.changeString( packageName,".","/" ) ;
        if( x.startsWith( "/" ) == true ) {
            x = x.substring( 1,x.length() ) ;
        }
        if( mode == false ) {
            x = baseDir + x + "/" + "entry/" + javaModelName + ".java" ;
        }
        else {
            x = baseDir + x + "/" + "dao/" + javaModelName + "Dao.java" ;
        }
        return FileUtil.getFullPath( x ) ;
    }
    
    private String getMethodFile() {
        StringBuilder buf = new StringBuilder( 4096 ) ;
        int len = params.size() ;
        for( int i = 0 ; i < len ; i ++ ) {
            buf.append( params.get( i ).getField() ) ;
        }
        for( int i = 0 ; i < len ; i ++ ) {
            buf.append( params.get( i ).getMethod() ) ;
        }
        String methods = buf.toString() ;
        buf = null ;
        return convert( ENTRY_TEMPLATE,methods ) ;
    }
    
    private String getDaoFile() {
        return convert( DAO_TEMPLATE,null ) ;
    }
    
    private String convert( String[] template,String methods ) {
        if( template == null ) {
            return "" ;
        }
        StringBuilder buf = new StringBuilder( 4096 ) ;
        int len = template.length ;
        for( int i = 0 ; i < len ; i ++ ) {
            buf.append( template[ i ] ).append( "\r\n" ) ;
        }
        SimpleDateFormat fmt = new SimpleDateFormat( "yyyy/MM/dd" ) ;
        String timestamp = fmt.format( new Date() ) ;
        fmt = null ;
        
        String ret = buf.toString() ;
        ret = StringUtil.changeString( ret,MODEL_NAME,DbUtil.convertDBNameByJavaName( true,modelName ) ) ;
        ret = StringUtil.changeString( ret,PACKAGE_NAME,packageName ) ;
        ret = StringUtil.changeString( ret,TIMESTAMP_NAME,timestamp ) ;
        if( methods != null ) {
            ret = StringUtil.changeString( ret,MODELS_NAME,methods ) ;
        }
        return ret ;
    }
    
    private static final String MODEL_NAME = "$(MODEL)" ;
    private static final String PACKAGE_NAME = "$(PACKAGE)" ;
    private static final String TIMESTAMP_NAME = "$(TIMESTAMP)" ;
    private static final String MODELS_NAME = "$(METHODS)" ;
    
    private static final String[] ENTRY_TEMPLATE = {
        "package $(PACKAGE).entry ;",
        "",
        "/**",
        " * $(MODEL) 情報.",
        " * ",
        " * @version $(TIMESTAMP).",
        " * @author MaaEngine(CreateEntry).",
        " * @since MaaEngine.",
        " */",
        "public class $(MODEL) {",
        "$(METHODS)",
        "}" } ;
    
    private static final String[] DAO_TEMPLATE = {
        "package $(PACKAGE).dao ;",
        "",
        "import $(PACKAGE).entry.$(MODEL) ;",
        "import org.maachang.dao.Dao ;",
        "",
        "/**",
        " * $(MODEL) Dao情報.",
        " * ",
        " * @version $(TIMESTAMP).",
        " * @author MaaEngine(CreateEntry).",
        " * @since MaaEngine.",
        " */",
        "public class $(MODEL)Dao extends Dao<$(MODEL)> {",
        "    /**",
        "     * コンストラクタ.",
        "     */",
        "    public $(MODEL)Dao() throws Exception {",
        "        super( $(MODEL).class ) ;",
        "    }",
        "    ",
        "}" } ;
}

class OneEntry {
    
    private String name = null ;
    private int type = -1 ;
    
    private OneEntry() {
        
    }
    
    public OneEntry( String name,String fieldType ) {
        int entryType = getFieldType( fieldType ) ;
        if( entryType != -1 ) {
            this.name = name ;
            this.type = entryType ;
        }
    }
    
    public static final int getFieldType( String fieldType ) {
        int entryType = -1 ;
        fieldType = fieldType.trim().toLowerCase() ;
        int len = Table.VALUE_TYPES.length ;
        for( int i = 0 ; i < len ; i ++ ) {
            if( Table.VALUE_TYPES[ i ].equals( fieldType ) ) {
                entryType = i ;
                break ;
            }
        }
        return entryType ;
    }
    
    public String getName() {
        return name ;
    }
    
    public int getType() {
        return type ;
    }
    
    public String getMethod() {
        return convert( METHOD_TEMPLATE ) ;
    }
    
    public String getField() {
        return convert( FIELD_TEMPLATE ) ;
    }
    
    private String convert( String[] template ) {
        if( name == null || type == -1 ) {
            return "" ;
        }
        String jname = DbUtil.convertDBNameByJavaName( true,name ) ;
        String jnameLow = jname.substring( 0,1 ).toLowerCase() + jname.substring( 1,jname.length() ) ;
        String jtype = Table.VALUE_JAVA_TYPES[ type ] ;
        
        StringBuilder buf = new StringBuilder( 1024 ) ;
        int len = template.length ;
        for( int i = 0 ; i < len ; i ++ ) {
            buf.append( "    " ).append( template[ i ] ).append( "\r\n" ) ;
        }
        String ret = buf.toString() ;
        ret = StringUtil.changeString( ret,FIELD_NAME,jname ) ;
        ret = StringUtil.changeString( ret,LFIELD_NAME,jnameLow ) ;
        return StringUtil.changeString( ret,TYPE_NAME,jtype ) ;
    }
    
    private static final String FIELD_NAME = "$(FIELD)" ;
    private static final String LFIELD_NAME = "$(LFIELD)" ;
    private static final String TYPE_NAME = "$(TYPE)" ;
    
    private static final String[] METHOD_TEMPLATE = {
        "/**",
        " * $(FIELD) を設定します.",
        " * <BR>",
        " * @param $(LFIELD) $(FIELD) を設定します.",
        " */",
        "public void set$(FIELD)( $(TYPE) $(LFIELD) ) {",
        "    this.$(LFIELD) = $(LFIELD) ;",
        "}",
        "",
        "/**",
        " * $(FIELD) を取得します.",
        " * <BR>",
        " * @return $(TYPE) $(FIELD) が返されます.",
        " */",
        "public $(TYPE) get$(FIELD)() {",
        "    return this.$(LFIELD) ;",
        "}","" } ;
    
    private static final String[] FIELD_TEMPLATE = {
        "/**",
        " * $(FIELD)情報.",
        " */",
        "private $(TYPE) $(LFIELD) = null ;","" } ;
    
}
