package org.maachang.dao.dbms.ctbl;

import org.maachang.engine.conf.Config;

/**
 * 生成テーブル管理.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class ConfigByOutputEntry {
    
    private String packageName = null ;
    private String outputSrcDir = null ;
    
    private ConfigByOutputEntry() {
    }
    
    public ConfigByOutputEntry( String packageName,String outputSrcDir )
        throws Exception {
        if( packageName == null || ( packageName = packageName.trim() ).length() <= 0 ||
            outputSrcDir == null || ( outputSrcDir = outputSrcDir.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.packageName = packageName ;
        this.outputSrcDir = outputSrcDir ;
    }
    
    public void output( Config params )
        throws Exception {
        Object[] sections = params.getSections() ;
        if( sections != null && sections.length > 0 ) {
            int len = sections.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( sections[ i ] != null ) {
                    createOneEntry( ( String )sections[ i ],params ) ;
                }
            }
        }
    }
    
    public void createOneEntry( String section,Config params )
        throws Exception {
        CreateEntry entry = new CreateEntry( packageName,section ) ;
        entry.add( "id","long" ) ;
        Object[] keys = params.getKeys( section ) ;
        if( keys != null && keys.length > 0 ) {
            int len = keys.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                
                String key = ( String )keys[ i ] ;
                String type = null ;
                
                if( "id".equals( key.toLowerCase() ) ) {
                    continue ;
                }
                
                String[] one = params.getAll( section,key ) ;
                int lenJ = one.length ;
                
                for( int j = 0 ; j < lenJ ; j ++ ) {
                    if( CreateEntry.getFieldType( one[ j ] ) != -1 ) {
                        type = one[ j ] ;
                        break ;
                    }
                }
                
                if( type != null ) {
                    entry.add( key,type ) ;
                }
            }
        }
        
        entry.getEntryFileOut( outputSrcDir ) ;
        entry.getDaoFileOut( outputSrcDir ) ;
    }
    
}
