package org.maachang.dao.dbms;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.maachang.dao.dbms.kind.KindManager;
import org.maachang.dao.dbms.kind.SupportKind;
import org.maachang.engine.conf.Config;
import org.maachang.engine.conf.ReadIni;

/**
 * DB情報を取得.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class DbmsInfo {
    
    /**
     * セクション名.
     */
    private static final String DBMS_SECTION = "dbms" ;
    
    /**
     * レコードファクトリを取得.
     * <BR><BR>
     * 指定条件からレコードファクトリを取得します.
     * <BR>
     * @param conf 対象のコンフィグ情報を設定します.
     * @return RecordFactory 対象のレコードファクトリが返されます.
     * @exception Exception 例外.
     */
    public static final RecordFactory getRecordFactory( Config conf )
        throws Exception {
        // ＤＢアクセス.
        String adapter = conf.get(DBMS_SECTION,"adapter",0);
        String driver = conf.get(DBMS_SECTION,"driver",0);
        String url = conf.get(DBMS_SECTION,"url",0);
        String user = conf.get(DBMS_SECTION,"user",0);
        String passwd = conf.get(DBMS_SECTION,"passwd",0);
        String max = conf.get(DBMS_SECTION,"max",0);
        String autoComit = conf.get(DBMS_SECTION,"autoComit",0);
        String checkSQL = conf.get(DBMS_SECTION,"checksql",0);
        
        int maxInt;
        try {
            maxInt = Integer.parseInt(max);
        } catch (Exception e) {
            maxInt = 15;
        }
        if (maxInt <= 0) {
            maxInt = 15;
        }
        boolean autoComitFlag = false ;
        try {
            autoComit = autoComit.trim().toLowerCase() ;
            autoComitFlag = autoComit.equals( "true" ) ;
        } catch( Exception e ) {
            autoComitFlag = false ;
        }
        SupportKind kind = KindManager.get( adapter ) ;
        if( kind == null ) {
            throw new IllegalArgumentException("非サポートのアダプタ名("+ adapter +
                ")が設定されています");
        }
        // Recordファクトリを登録.
        RecordFactory ret = new RecordFactory();
        ret.create(kind,driver, url, user, passwd, maxInt, autoComitFlag, checkSQL);
        return ret ;
    }
    
    /**
     * 指定されたコンフィグファイルを取得.
     * <BR><BR>
     * 指定されたコンフィグファイルを取得します.
     * <BR>
     * @param name 対象のコンフィグファイル名を設定します.
     * @return Config 対象のコンフィグファイルが返されます.
     * @exception Exception 例外.
     */
    public static final Config getConfig( String name )
        throws Exception {
        return getConfig( new FileInputStream( name ) ) ;
    }
    
    /**
     * 指定されたコンフィグファイルを取得.
     * <BR><BR>
     * 指定されたコンフィグファイルを取得します.
     * <BR>
     * @param in 対象のInputStreamを設定します.
     * @return Config 対象のコンフィグファイルが返されます.
     * @exception Exception 例外.
     */
    public static final Config getConfig( InputStream in )
        throws Exception {
        BufferedReader buf = null ;
        try {
            Config ret = new Config() ;
            buf = new BufferedReader( new InputStreamReader( in,"UTF8" ) ) ;
            ReadIni.analisys( ret,buf ) ;
            buf.close() ;
            buf = null ;
            return ret ;
        } finally {
            if( buf != null ) {
                try {
                    buf.close() ;
                } catch( Exception e ) {
                }
            }
            buf = null ;
        }
    }
}

