package org.maachang.dao.dbms;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.Types;

/**
 * DBユーティリティ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaaEngine 1.00
 */
public class DbUtil {

    /**
     * 指定ResultSetの内容をオブジェクトに割り当てる.
     */
    public static final void convertResultByObject(Object out, ResultSet result)
            throws Exception {
        if (out == null || result == null) {
            return ;
        }
        MetaColumn meta = new MetaColumn(out.getClass().getName(), result
                .getMetaData());
        Class oClass = out.getClass();
        int len = meta.size();
        for (int i = 0; i < len; i++) {
            String name = meta.getColumnName(i);
            String javaName = convertDBNameByJavaName(false, name);
            Object value = result.getObject(name);
            if (value != null) {
                String mName = new StringBuilder().append("set").append(
                        javaName.substring(0, 1).toUpperCase()).append(
                        javaName.substring(1, javaName.length())).toString();
                // char(1)の条件は、Booleanと同様の扱いとする.
                if( meta.getColumnType( i ) == Types.CHAR ) {
                    String c = ( String )value ;
                    if( c.length() == 1 ) {
                        if( c.equals( "0" ) ) {
                            value = new Boolean( false ) ;
                        }
                        else {
                            value = new Boolean( true ) ;
                        }
                    }
                }
                // データをセットできた場合のみ設定する.
                try {
                    Method md = oClass.getMethod(mName, value.getClass());
                    md.invoke(out, value);
                } catch( Exception e ) {
                }
            }
        }
    }

    /**
     * Java用データ名をDB用データ名に変換.
     */
    public static final String convertJavaNameByDBName(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        int len = name.length();
        StringBuilder buf = new StringBuilder();
        buf.append(name.charAt(0));
        for (int i = 1; i < len; i++) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                buf.append("_");
            }
            buf.append(c);
        }
        String ret = buf.toString().toLowerCase();
        return ret;
    }

    /**
     * DB用データ名をJava用データ名に変換.
     */
    public static final String convertDBNameByJavaName(boolean table,
            String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        name = name.toLowerCase();
        int len = name.length();
        StringBuilder buf = new StringBuilder();
        buf.append(name.charAt(0));
        for (int i = 1; i < len; i++) {
            char c = name.charAt(i);
            if (c == '_') {
                if (i + 1 < len) {
                    char cp = name.charAt(i + 1);
                    if (cp >= 'a' && cp <= 'z') {
                        buf.append((char) ('A' + (cp - 'a')));
                        i++;
                        continue;
                    }
                }
                continue;
            }
            buf.append(c);
        }
        String ret = buf.toString();
        buf = null;
        if (table == true) {
            char c = ret.charAt(0);
            if (c >= 'a' && c <= 'z') {
                buf = new StringBuilder();
                buf.append((char) ('A' + (c - 'a'))).append(
                        ret.substring(1, ret.length()));
                ret = buf.toString();
            }
        }
        return ret;
    }
}
