package test.action;

import org.maachang.engine.Action;
import org.maachang.engine.servlet.Parameter;
import org.maachang.engine.servlet.ResultMessage;
import org.maachang.engine.servlet.Validate;

import test.action.form.SamplesForm;
import test.db.dao.SamplesDao;

public class SamplesAction extends Action<SamplesForm> {
    
    private SamplesDao samplesDao = null ;
    public void setSamplesDao( SamplesDao samplesDao ) {
        this.samplesDao = samplesDao ;
    }
    
    public SamplesAction() {
        super( true ) ;// validateを有効に設定.
    }
    
    @Override
    public String execution(ResultMessage result, SamplesForm fobj, Parameter params)
        throws Exception {
        samplesDao.save( fobj ) ;
        result.setSuccessMessage( "ユーザ名:["+fobj.getName() + "]は正常に登録できました" ) ;
        return "samples.jsp" ;
    }
    
    @Override
    public String validate(Validate validate,ResultMessage result,SamplesForm fobj,Parameter parameter) throws Exception {
        validate.setErrorForward( "samples.jsp" ) ;
        validate.append( "text","name",
        "ユーザ名は、英数で、6文字以上、32文字以下で設定してください","type=ascii","min=6","max=32" ).
            append( "text","passwd","パスワードは、英数で設定してください","type=ascii","min=1","max=32" ) ;
        if( validate.isValidate() == false ) {
            if( samplesDao.count( "where name=?",fobj.getName() ) > 0 ) {
                result.setErrorMessage( "既に同一名のユーザ名が存在します" ) ;
                return validate.getErrorFroward() ;
            }
        }
        return null ;
    }

}
