/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.service.mail;

import java.io.BufferedReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.maachang.engine.util.Reflect;
import org.maachang.service.mail.MailAuth;
import org.maachang.service.mail.ResultAttached;
import org.maachang.service.mail.SendMail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendMailService {
    private static final String CHARSET = "ISO-2022-JP";

    public void sendMail(SendMail sendMail) throws Exception {
        if (sendMail == null || !sendMail.check()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", sendMail.getHost());
        if (sendMail.getPort() > 0) {
            props.put("mail.smtp.port", String.valueOf(sendMail.getPort()));
        }
        if (sendMail.getTimeout() > 0L) {
            props.setProperty("mail.smtp.connectiontimeout", String.valueOf(sendMail.getTimeout()));
            props.setProperty("mail.smtp.timeout", String.valueOf(sendMail.getTimeout()));
        }
        if (sendMail.isSsl()) {
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            if (sendMail.getPort() > 0) {
                props.setProperty("mail.smtp.socketFactory.port", String.valueOf(sendMail.getPort()));
            }
        }
        Session session = null;
        if (sendMail.isAuth()) {
            props.setProperty("mail.smtp.auth", "true");
            session = Session.getInstance((Properties)props, (Authenticator)new MailAuth(sendMail.getUser(), sendMail.getPasswd()));
        } else {
            session = Session.getInstance((Properties)props, null);
        }
        MimeMessage msg = new MimeMessage(session);
        msg.setHeader("Content-Type", "text/plain; charset=ISO-2022-JP");
        msg.setHeader("Content-Transfer-Encoding", "7bit");
        msg.setFrom((Address)new InternetAddress(sendMail.getFrom()));
        InternetAddress[] address = this.getTo(sendMail);
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        msg.setSubject(MimeUtility.encodeText((String)sendMail.getSubject(), (String)CHARSET, (String)"B"));
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setHeader("Content-Transfer-Encoding", "7bit");
        textPart.setText(this.getSendMessage(sendMail), CHARSET);
        multipart.addBodyPart((BodyPart)textPart);
        if (sendMail.getAttached() != null && sendMail.getAttached().size() > 0) {
            ArrayList<ResultAttached> lst = sendMail.getAttached();
            MimeBodyPart attachmentPart = new MimeBodyPart();
            int len = lst.size();
            int i = 0;
            while (i < len) {
                ResultAttached ra = lst.get(i);
                if (ra != null && ra.getAttached() != null && ra.getAttached().length > 0) {
                    ByteArrayDataSource ba = new ByteArrayDataSource(ra.getAttached(), "application/octet-stream");
                    attachmentPart.setDataHandler(new DataHandler((DataSource)ba));
                    if (ra.getFileName() != null && ra.getFileName().length() > 0) {
                        attachmentPart.setFileName(MimeUtility.encodeText((String)ra.getFileName(), (String)CHARSET, null));
                    }
                    multipart.addBodyPart((BodyPart)attachmentPart);
                }
                ++i;
            }
        }
        msg.setContent((Multipart)multipart);
        msg.setSentDate(new Date());
        Transport.send((Message)msg);
    }

    private InternetAddress[] getTo(SendMail sendMail) throws Exception {
        int len = sendMail.getTo().size();
        InternetAddress[] ret = new InternetAddress[len];
        int i = 0;
        while (i < len) {
            ret[i] = new InternetAddress(sendMail.getTo().get(i));
            ++i;
        }
        return ret;
    }

    private String getSendMessage(SendMail sendMail) throws Exception {
        StringWriter w = new StringWriter();
        Velocity.evaluate((Context)new VelocityContext(this.getMap(sendMail)), (Writer)w, null, (String)this.trimBody(sendMail.getBody()));
        w.flush();
        return w.toString();
    }

    private HashMap<String, Object> getMap(SendMail sendMail) throws Exception {
        HashMap<String, Object> ret = Reflect.getter(sendMail.getParams());
        int size = ret.size();
        if (size > 0) {
            Object[] objs = ret.keySet().toArray();
            int i = 0;
            while (i < size) {
                Object val = ret.get((String)objs[i]);
                if (val == null) {
                    ret.put((String)objs[i], "");
                }
                ++i;
            }
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 - HH\u6642mm\u5206ss\u79d2", Locale.JAPAN);
            ret.put("createMailSendDate", fmt.format(new Date()));
            return ret;
        }
        return ret;
    }

    private String trimBody(String body) throws Exception {
        String s;
        BufferedReader b = new BufferedReader(new StringReader(body));
        StringBuilder buf = new StringBuilder((int)((float)body.length() * 1.25f));
        while ((s = b.readLine()) != null) {
            buf.append(s);
            buf.append("\r\n");
        }
        b.close();
        return buf.toString();
    }
}

