/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.service.http;

import java.util.ArrayList;
import java.util.HashMap;
import org.maachang.service.http.NullObjectHeader;

public class HttpHeader {
    private HashMap<String, ArrayList<Object>> headers = null;

    protected void finalize() throws Exception {
        this.headers = null;
    }

    public void add(HttpHeader header) {
        if (header == null || header.size() <= 0) {
            return;
        }
        String[] keys = header.getKeys();
        if (keys != null) {
            int len = keys.length;
            int i = 0;
            while (i < len) {
                int lenJ = header.size(keys[i]);
                int j = 0;
                while (j < lenJ) {
                    this.addHeader(keys[i], header.getHeader(keys[i], j));
                    ++j;
                }
                ++i;
            }
        }
    }

    public void addHeader(String key, String value) {
        this.pushHeader(false, key, value);
    }

    public void setHeader(String key, String value) {
        this.pushHeader(true, key, value);
    }

    private void pushHeader(boolean mode, String key, String value) {
        Object val = null;
        if (key == null) {
            return;
        }
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        val = value == null ? new NullObjectHeader() : value;
        if (mode) {
            ArrayList<Object> lst = new ArrayList<Object>();
            lst.add(val);
            this.headers.put(key, lst);
        } else {
            ArrayList<Object> lst = this.headers.get(key);
            if (lst == null) {
                lst = new ArrayList();
                this.headers.put(key, lst);
            }
            lst.add(val);
        }
    }

    public void removeHeader(String key) {
        if (key == null || this.headers == null) {
            return;
        }
        this.headers.remove(key);
    }

    public void removeHeader(String key, int no) {
        if (key == null || this.headers == null || no < 0) {
            return;
        }
        ArrayList<Object> lst = this.headers.get(key);
        if (lst == null || lst.size() <= no) {
            return;
        }
        lst.remove(no);
        if (lst.size() <= 0) {
            this.headers.remove(key);
        }
    }

    public String getHeader(String key) {
        return this.getHeader(key, 0);
    }

    public String getHeader(String key, int no) {
        if (key == null || this.headers == null || no < 0) {
            return null;
        }
        ArrayList<Object> lst = this.headers.get(key);
        if (lst == null || lst.size() <= no) {
            return null;
        }
        Object ret = lst.get(no);
        if (ret == null || ret instanceof NullObjectHeader) {
            return null;
        }
        return (String)ret;
    }

    public int size() {
        return this.headers == null ? 0 : this.headers.size();
    }

    public int size(String key) {
        if (key == null || this.headers == null) {
            return 0;
        }
        ArrayList<Object> lst = this.headers.get(key);
        if (lst == null) {
            return 0;
        }
        return lst.size();
    }

    public String[] getKeys() {
        if (this.headers == null || this.headers.size() <= 0) {
            return null;
        }
        Object[] keys = this.headers.keySet().toArray();
        if (keys != null) {
            int len = keys.length;
            String[] ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = (String)keys[i];
                ++i;
            }
            return ret;
        }
        return null;
    }

    public boolean isKey(String key) {
        if (this.headers == null) {
            return false;
        }
        return this.headers.get(key) != null;
    }

    public String toString() {
        String[] keys = this.getKeys();
        if (keys != null) {
            StringBuilder buf = new StringBuilder();
            int len = keys.length;
            int i = 0;
            while (i < len) {
                ArrayList<Object> lst;
                if (i != 0) {
                    buf.append(",");
                }
                if ((lst = this.headers.get(keys[i])) != null) {
                    int lenJ = lst.size();
                    int j = 0;
                    while (j < lenJ) {
                        if (j != 0) {
                            buf.append(",");
                        }
                        Object objs = lst.get(j);
                        buf.append(" [").append(keys[i]).append(":");
                        if (objs == null || objs instanceof NullObjectHeader) {
                            buf.append("]");
                        } else {
                            buf.append(objs).append("]");
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return buf.toString();
        }
        return "null";
    }
}

