/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.validate;

import java.util.HashMap;
import org.maachang.engine.util.KeyValue;
import org.maachang.engine.validate.AbstractValidateElement;
import org.maachang.engine.validate.ValidateElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextValidateElement
extends AbstractValidateElement
implements ValidateElement {
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_MIN_LENGTH = "min";
    private static final String PARAM_MAX_LENGTH = "max";
    private static final String ONLY_NUMBER = "num";
    private static final String ONLY_ALPHABET = "alpha";
    private static final String ONLY_ASCII = "ascii";
    private static final String ONLY_KANA = "kana";
    private static final String ONLY_HIRA = "hira";
    private static final String KANA = "\u30a2\u30a3\u30a4\u30a6\u30a6\u30a7\u30a8\u30a9\u30aa\u30ab\u30ac\u30ad\u30ae\u30af\u30b0\u30b1\u30b2\u30b3\u30b4\u30b5\u30b6\u30b7\u30b8\u30b9\u30ba\u30bb\u30bc\u30bd\u30be\u30bf\u30c0\u30c1\u30c2\u30c3\u30c4\u30c5\u30c6\u30c7\u30c8\u30c9\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d0\u30d1\u30d2\u30d3\u30d4\u30d5\u30d6\u30d7\u30d8\u30d9\u30da\u30db\u30dc\u30dd\u30de\u30df\u30e0\u30e1\u30e2\u30e3\u30e4\u30e5\u30e6\u30e7\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ee\u30ef\u30f0\u30f2\u30f3\u30fc";
    private static final String HIRA = "\u3042\u3043\u3044\u3045\u3046\u3047\u3048\u3049\u304a\u304b\u304c\u304d\u304e\u304f\u3050\u3051\u3052\u3053\u3054\u3055\u3056\u3057\u3058\u3059\u305a\u305b\u305c\u305d\u305e\u305f\u3060\u3061\u3062\u3063\u3064\u3065\u3066\u3067\u3068\u3069\u306a\u306b\u306c\u306d\u306e\u306f\u3070\u3071\u3072\u3073\u3074\u3075\u3076\u3077\u3078\u3079\u307a\u307b\u307c\u307d\u307e\u307f\u3080\u3081\u3082\u3083\u3084\u3085\u3086\u3087\u3088\u3089\u308a\u308b\u308c\u308d\u308e\u308f\u3090\u3091\u3092\u3093\u30fc";

    @Override
    public boolean match(Object check, String[] args) throws Exception {
        if (!(check == null || check instanceof String || check instanceof Integer || check instanceof Long || check instanceof Float || check instanceof Double)) {
            return false;
        }
        if (check == null) {
            check = "";
        }
        HashMap<String, KeyValue> keyValue = this.getUseParams(args);
        String chkString = check.toString();
        if (!this.checkType(chkString, keyValue)) {
            return false;
        }
        if (!this.minLength(chkString, keyValue)) {
            return false;
        }
        return this.maxLength(chkString, keyValue);
    }

    @Override
    public String getName() {
        return "text";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkType(String chkString, HashMap<String, KeyValue> keyValue) {
        KeyValue kv = keyValue.get(PARAM_TYPE);
        if (kv == null) {
            return true;
        }
        String type = kv.getValue();
        if (chkString == null || chkString.length() <= 0 || type == null) {
            return true;
        }
        if (type.startsWith(ONLY_NUMBER)) {
            int len = chkString.length();
            int cnt = 0;
            int i = 0;
            while (i < len) {
                char c = chkString.charAt(i);
                if (c < '0' || c > '9') {
                    if (cnt == 0) {
                        if (i != 0 || c != '-') return false;
                        cnt = -1;
                    } else if (cnt != 0 && c != '.') {
                        return false;
                    }
                }
                ++cnt;
                ++i;
            }
            return true;
        } else if (type.startsWith(ONLY_ALPHABET)) {
            int len = chkString.length();
            int i = 0;
            while (i < len) {
                char c = chkString.charAt(i);
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    return false;
                }
                ++i;
            }
            return true;
        } else if (type.startsWith(ONLY_ASCII)) {
            int len = chkString.length();
            int i = 0;
            while (i < len) {
                char c = chkString.charAt(i);
                if (c > '\u00ff') {
                    return false;
                }
                ++i;
            }
            return true;
        } else if (type.startsWith(ONLY_KANA)) {
            int len = chkString.length();
            int i = 0;
            while (i < len) {
                String c = chkString.substring(i, i + 1);
                if (KANA.indexOf(c) == -1) {
                    return false;
                }
                ++i;
            }
            return true;
        } else {
            if (!type.startsWith(ONLY_HIRA)) return true;
            int len = chkString.length();
            int i = 0;
            while (i < len) {
                String c = chkString.substring(i, i + 1);
                if (HIRA.indexOf(c) == -1) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean minLength(String chkString, HashMap<String, KeyValue> keyValue) {
        KeyValue kv = keyValue.get(PARAM_MIN_LENGTH);
        if (kv == null) {
            return true;
        }
        String min = kv.getValue();
        if (min == null) {
            return true;
        }
        int len = -1;
        try {
            len = Integer.parseInt(min);
        }
        catch (Exception e) {
            len = -1;
        }
        if (len == -1) {
            return true;
        }
        return chkString.length() >= len;
    }

    private boolean maxLength(String chkString, HashMap<String, KeyValue> keyValue) {
        KeyValue kv = keyValue.get(PARAM_MAX_LENGTH);
        if (kv == null) {
            return true;
        }
        String max = kv.getValue();
        if (max == null) {
            return true;
        }
        int len = -1;
        try {
            len = Integer.parseInt(max);
        }
        catch (Exception e) {
            len = -1;
        }
        if (len == -1) {
            return true;
        }
        return chkString.length() <= len;
    }
}

