/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.util;

public class Sequence {
    public static final int NOT_ID = Integer.MIN_VALUE;
    protected int maxId = 0;
    protected int startId = 0;
    protected int id = 0;
    protected long returnTimeout = 0L;
    protected final Object sync = new Object();

    public Sequence() {
        this.create();
    }

    public Sequence(int start, int max) {
        try {
            this.create(start, max);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void create() {
        try {
            this.create(0, Integer.MAX_VALUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(int start, int max) throws Exception {
        if (start < 0 || max <= 1 || start >= max - 1 || max > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        try {
            Object object = this.sync;
            synchronized (object) {
                this.maxId = max;
                this.startId = start;
                this.id = start;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            Object object = this.sync;
            synchronized (object) {
                this.id = this.startId;
                this.returnTimeout = System.currentTimeMillis();
            }
        }
        catch (NullPointerException nul) {
            this.id = this.startId;
            this.returnTimeout = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId() {
        int ret;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.id;
                if (ret >= this.maxId) {
                    this.returnTimeout = System.currentTimeMillis();
                    this.id = this.startId;
                } else {
                    this.id = ret + 1;
                }
            }
        }
        catch (NullPointerException nul) {
            ret = Integer.MIN_VALUE;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextId(int id) {
        try {
            Object object = this.sync;
            synchronized (object) {
                this.id = id <= this.startId || id >= this.maxId ? (id <= this.startId ? this.startId : this.maxId) : id;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStartId() {
        int ret;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.startId;
            }
        }
        catch (NullPointerException nul) {
            ret = Integer.MIN_VALUE;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxID() {
        int ret;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.maxId;
            }
        }
        catch (NullPointerException nul) {
            ret = Integer.MIN_VALUE;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReturnIDByTime() {
        long ret;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.returnTimeout;
            }
        }
        catch (NullPointerException nul) {
            ret = 0L;
        }
        return ret;
    }
}

