/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.util;

import java.util.List;
import org.maachang.engine.util.LinkChild;
import org.maachang.engine.util.LinkEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkList<E> {
    protected LinkChild<E> first = null;
    protected LinkChild<E> last = null;
    protected int size = 0;

    public void clear() {
        this.first = null;
        this.last = null;
    }

    public LinkEntry<E> add(E o) {
        if (this.first == null) {
            this.first = new LinkChild();
            this.first.parent = this;
            this.first.before = null;
            this.first.next = null;
            this.first.value = o;
            this.last = this.first;
            this.size = 1;
            return this.first;
        }
        LinkChild lnk = new LinkChild();
        lnk.parent = this;
        lnk.next = null;
        lnk.before = this.last;
        lnk.value = o;
        this.last.next = lnk;
        this.last = lnk;
        ++this.size;
        return lnk;
    }

    public LinkEntry<E> set(int no, E o) {
        if (this.first == null) {
            return null;
        }
        LinkChild<E> lnk = this.first;
        int i = 0;
        while (i < no) {
            if (lnk.next == null) break;
            lnk = lnk.next;
            ++i;
        }
        lnk.value = o;
        return lnk;
    }

    public LinkEntry<E> bitween(int no, E o) {
        if (this.first == null) {
            return this.add(o);
        }
        if (no <= -1) {
            LinkChild ad = new LinkChild();
            ad.parent = this;
            ad.before = null;
            ad.next = this.first;
            ad.value = o;
            this.first.before = ad;
            this.first = ad;
            ++this.size;
            return ad;
        }
        LinkChild<E> lnk = this.first;
        int i = 0;
        while (i < no) {
            if (lnk.next == null) break;
            lnk = lnk.next;
            ++i;
        }
        LinkChild ad = new LinkChild();
        ad.parent = this;
        ad.next = lnk.next;
        if (lnk.next != null) {
            lnk.next.before = ad;
        } else {
            this.last = ad;
        }
        ad.before = lnk;
        lnk.next = ad;
        ad.value = o;
        ++this.size;
        return ad;
    }

    public E remove(int no) {
        if (this.first == null) {
            return null;
        }
        LinkChild<E> lnk = this.first;
        int i = 0;
        while (i < no) {
            if (lnk.next == null) {
                return null;
            }
            lnk = lnk.next;
            ++i;
        }
        if (lnk.before != null) {
            lnk.before.next = lnk.next;
        } else {
            this.first = lnk.next;
        }
        if (lnk.next != null) {
            lnk.next.before = lnk.before;
        } else {
            this.last = lnk.before;
        }
        --this.size;
        lnk.before = null;
        lnk.next = null;
        return lnk.value;
    }

    public E removeFirst() {
        if (this.first == null) {
            return null;
        }
        Object ret = this.first.value;
        if (this.first.next != null) {
            LinkChild<E> lnk = this.first;
            lnk.next.before = null;
            this.first = lnk.next;
            lnk.before = null;
            lnk.next = null;
        } else {
            this.first = null;
            this.last = null;
        }
        --this.size;
        return ret;
    }

    public E removeLast() {
        if (this.first == null) {
            return null;
        }
        Object ret = this.last.value;
        if (this.last.before != null) {
            LinkChild<E> lnk = this.last;
            lnk.before.next = null;
            this.last = lnk.before;
            lnk.before = null;
            lnk.next = null;
        } else {
            this.first = null;
            this.last = null;
        }
        --this.size;
        return ret;
    }

    public E get(int no) {
        if (this.first == null) {
            return null;
        }
        LinkChild<E> lnk = this.first;
        int i = 0;
        while (i < no) {
            if (lnk.next == null) {
                return null;
            }
            lnk = lnk.next;
            ++i;
        }
        if (lnk != null) {
            return lnk.value;
        }
        return null;
    }

    public E getFirst() {
        if (this.first == null) {
            return null;
        }
        return this.first.value;
    }

    public E getLast() {
        if (this.first == null) {
            return null;
        }
        return this.last.value;
    }

    public int size() {
        return this.size;
    }

    public Object[] getAll() {
        if (this.first == null) {
            return null;
        }
        Object[] ret = new Object[this.size];
        LinkChild<E> lnk = this.first;
        int i = 0;
        while (i < this.size) {
            ret[i] = lnk.value;
            lnk = lnk.next;
            ++i;
        }
        return ret;
    }

    public void getAll(List<E> o) {
        if (o == null || this.first == null) {
            return;
        }
        LinkChild<E> lnk = this.first;
        do {
            o.add(lnk.value);
        } while ((lnk = lnk.next) != null);
    }

    public String toString() {
        if (this.first == null) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        LinkChild<E> lnk = this.first;
        int i = 0;
        while (lnk != null) {
            if (i != 0) {
                buf.append(",");
            }
            if (lnk.value == null) {
                buf.append("");
            } else {
                buf.append(lnk.value);
            }
            lnk = lnk.next;
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }
}

