/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.MessageDigest;

public class Digest {
    private static final int BUFFER = 1024;

    public static final byte[] convert(String digest, InputStream stream) throws Exception {
        BufferedInputStream bi = null;
        MessageDigest md = null;
        byte[] buf = null;
        byte[] ret = null;
        if (stream == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                int len;
                md = MessageDigest.getInstance(digest);
                bi = new BufferedInputStream(stream);
                buf = new byte[1024];
                while ((len = bi.read(buf)) > 0) {
                    md.update(buf, 0, len);
                }
                ret = md.digest();
            }
            catch (Exception e) {
                ret = null;
                throw e;
            }
        }
        finally {
            try {
                bi.close();
            }
            catch (Exception exception) {}
            bi = null;
            buf = null;
            md = null;
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public static final byte[] convertBinary(String digest, byte[] bin) throws Exception {
        void var2_2;
        int len;
        if (bin == null || (len = bin.length) <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return Digest.convertBinary(digest, bin, 0, (int)var2_2);
    }

    public static final byte[] convertBinary(String digest, byte[] bin, int length) throws Exception {
        return Digest.convertBinary(digest, bin, 0, length);
    }

    public static final byte[] convertBinary(String digest, byte[] bin, int offset, int length) throws Exception {
        MessageDigest md = null;
        byte[] ret = null;
        if (bin == null || bin.length <= 0 || offset < 0 || length < 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                md = MessageDigest.getInstance(digest);
                md.update(bin, offset, length);
                ret = md.digest();
            }
            catch (Exception e) {
                ret = null;
                throw e;
            }
        }
        finally {
            md = null;
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public static final String convert(String digest, byte[] bin) throws Exception {
        void var2_2;
        int len;
        if (bin == null || (len = bin.length) <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return Digest.convert(digest, bin, 0, (int)var2_2);
    }

    public static final String convert(String digest, byte[] bin, int length) throws Exception {
        return Digest.convert(digest, bin, 0, length);
    }

    public static final String convert(String digest, byte[] bin, int offset, int length) throws Exception {
        byte[] tmp = null;
        StringBuffer buf = null;
        MessageDigest md = null;
        String ret = null;
        if (bin == null || bin.length <= 0 || offset < 0 || length < 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                md = MessageDigest.getInstance(digest);
                md.update(bin, offset, length);
                tmp = md.digest();
                int len = tmp.length;
                buf = new StringBuffer(len);
                int i = 0;
                while (i < len) {
                    buf.append(Integer.toString((tmp[i] & 0xF0) >> 4, 16));
                    buf.append(Integer.toString(tmp[i] & 0xF, 16));
                    ++i;
                }
                ret = buf.toString();
            }
            catch (Exception e) {
                ret = null;
                throw e;
            }
        }
        finally {
            md = null;
            tmp = null;
            buf = null;
        }
        return ret;
    }

    private Digest() {
    }
}

