/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.servlet;

import org.apache.velocity.app.Velocity;
import org.maachang.dao.dbms.DbmsInfo;
import org.maachang.dao.dbms.RecordFactory;
import org.maachang.engine.conf.Config;
import org.maachang.engine.servlet.DiContainer;
import org.maachang.engine.servlet.GlobalInfo;
import org.maachang.engine.servlet.PageSessionManager;
import org.maachang.engine.servlet.ValidateManager;
import org.maachang.engine.util.FileUtil;

class InitServlet {
    private static final long DEF_TIMETOUT = 1800000L;
    private static final String PROPERTY_FILE = "maaEngine.conf";
    private static final InitServlet SNGL = new InitServlet();
    private boolean initServletFlag = false;

    InitServlet() {
    }

    public static final InitServlet getInstance() {
        return SNGL;
    }

    public synchronized boolean isStartup() {
        return this.initServletFlag;
    }

    public synchronized void init(String readConfig, String realPath) throws Exception {
        if (!this.initServletFlag) {
            if (readConfig == null || (readConfig = readConfig.trim()).length() <= 0) {
                readConfig = PROPERTY_FILE;
            }
            realPath = FileUtil.getFullPath(realPath);
            Config conf = this.getIniParams(realPath, readConfig);
            RecordFactory rec = DbmsInfo.getRecordFactory(conf);
            GlobalInfo.setRealPath(realPath);
            GlobalInfo.setRecordFactory(rec);
            GlobalInfo.setDiContainer(new DiContainer());
            GlobalInfo.setKind(rec.getSupportKind());
            GlobalInfo.setConfig(conf);
            Velocity.init();
            GlobalInfo.setPageSessionManager(this.getPageSessionManager(conf));
            GlobalInfo.setValidateManager(ValidateManager.getValidateManager(conf));
            this.initServletFlag = true;
        }
    }

    private Config getIniParams(String realPath, String readConfig) throws Exception {
        String web_inf = FileUtil.marge(realPath, "WEB-INF");
        String confFile = FileUtil.marge(web_inf, readConfig);
        if (FileUtil.isFileExists(confFile)) {
            return DbmsInfo.getConfig(confFile);
        }
        return DbmsInfo.getConfig(Thread.currentThread().getContextClassLoader().getResourceAsStream(readConfig));
    }

    private PageSessionManager getPageSessionManager(Config config) {
        long time = config.getInt("pageSession", "timeout", 0);
        if (time == -1L) {
            time = 1800000L;
        }
        return new PageSessionManager(time);
    }
}

