/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.servlet;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;

public class DownloadInfo {
    private InputStream stream = null;
    private String mimeType = null;
    private long createTime = -1L;
    private String address = null;
    private String userAgent = null;

    private DownloadInfo() {
    }

    protected DownloadInfo(HttpServletRequest request, String mimeType, InputStream stream) throws Exception {
        if (request == null || stream == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (mimeType == null || (mimeType = mimeType.trim()).length() <= 0) {
            mimeType = "application/octet-stream";
        }
        this.stream = stream;
        this.mimeType = mimeType;
        this.address = request.getRemoteAddr();
        this.userAgent = request.getHeader("User-Agent");
        this.createTime = System.currentTimeMillis();
    }

    public void clear() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.stream = null;
        this.mimeType = null;
        this.createTime = -1L;
        this.address = null;
        this.userAgent = null;
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getAddress() {
        return this.address;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public long getCreateTime() {
        return this.createTime;
    }
}

