/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.servlet;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.maachang.engine.servlet.DownloadInfo;
import org.maachang.engine.servlet.GlobalInfo;
import org.maachang.engine.util.RandomUtil;

public class DownloadFilter
implements Filter {
    public static final String DOWNLOAD_PARAM = "_downloadId";
    public static final int DOWNLOAD_KEY_LENGTH = 48;
    private static final String CHARSET = "UTF8";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setCharacterEncoding(CHARSET);
        String downloadId = null;
        downloadId = request.getParameter(DOWNLOAD_PARAM);
        if (downloadId != null && (downloadId = downloadId.trim()).length() == 48) {
            int b;
            Hashtable<String, DownloadInfo> man = GlobalInfo.getDownloadKey();
            DownloadInfo di = man.remove(downloadId);
            if (di == null || !request.getRemoteAddr().equals(di.getAddress()) || !((HttpServletRequest)request).getHeader("User-Agent").equals(di.getUserAgent())) {
                throw new IOException("\u6307\u5b9a\u30ad\u30fc\u306e\u60c5\u5831(" + downloadId + ")\u306f\u4e0d\u6b63\u3067\u3059");
            }
            response.setContentType(di.getMimeType());
            InputStream is = di.getInputStream();
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            while ((b = is.read()) != -1) {
                ((OutputStream)out).write(b);
            }
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        } else {
            chain.doFilter(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String setDownloadInfo(HttpServletRequest request, String mimeType, InputStream stream) throws Exception {
        Hashtable<String, DownloadInfo> man = GlobalInfo.getDownloadKey();
        while (true) {
            String key = RandomUtil.randomString(48, true, true, true);
            Hashtable<String, DownloadInfo> hashtable = man;
            synchronized (hashtable) {
                if (man.get(key) == null) {
                    man.put(key, new DownloadInfo(request, mimeType, stream));
                    return key;
                }
            }
            try {
                Thread.sleep(30L);
            }
            catch (Exception exception) {
            }
        }
    }
}

