/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.servlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.engine.servlet.HttpBinary;
import org.maachang.engine.servlet.HttpBinaryImpl;
import org.maachang.engine.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConvertHttpParams {
    private static final Log LOG = LogFactory.getLog(ConvertHttpParams.class);
    private static final String CHARSET = "UTF8";
    private static final String MULTIPART_FORM = "multipart/form-data";
    private static final String MULTIPART_START = "boundary=";

    ConvertHttpParams() {
    }

    public static final HashMap<String, Object> getParams(HttpServletRequest request) throws Exception {
        int p;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String multiPartForm = null;
        String ctxType = request.getContentType();
        if (ctxType != null && ctxType.startsWith(MULTIPART_FORM) && (p = ctxType.indexOf(MULTIPART_START)) != -1) {
            multiPartForm = ctxType.substring(p + MULTIPART_START.length(), ctxType.length()).trim();
        }
        if (multiPartForm != null) {
            ConvertHttpParams.analysisMultiPartForm(ret, multiPartForm, ConvertHttpParams.getInputStreamByBytes((InputStream)request.getInputStream()));
        } else {
            Object[] objs;
            request.setCharacterEncoding(CHARSET);
            Map map = request.getParameterMap();
            if (map != null && (objs = map.keySet().toArray()) != null && objs.length > 0) {
                int len = objs.length;
                int i = 0;
                while (i < len) {
                    String key = (String)objs[i];
                    Object params = map.get(key);
                    ConvertHttpParams.putRequestParams(ret, key, params);
                    ++i;
                }
            }
        }
        LOG.info((Object)("## (url):" + request.getRequestURL() + " [" + request.getRemoteAddr() + "] - $params:" + ret));
        return ret;
    }

    private static final void analysisMultiPartForm(HashMap<String, Object> out, String multiPartForm, byte[] binary) throws Exception {
        int p = 0;
        int b = 0;
        String enter = "\r\n";
        int enterLen = enter.length();
        String target = "--" + multiPartForm;
        String end = String.valueOf(target) + "--";
        String keyName = null;
        String fileName = null;
        String mimeType = null;
        boolean dataFlag = false;
        boolean keyFlag = false;
        while (true) {
            String one;
            if (!dataFlag) {
                int namePnt;
                int filePnt;
                p = ConvertHttpParams.getIndexOf(binary, b, enter);
                if (p == -1) break;
                one = new String(binary, b, p - b, CHARSET);
                b = p + enterLen;
                if (!keyFlag) {
                    if (one.equals(target)) {
                        keyFlag = true;
                        continue;
                    }
                    if (one.equals(end)) break;
                    throw new IllegalArgumentException("\u4e0d\u6b63\u306a\u6761\u4ef6\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                }
                if (one.length() <= 0) {
                    dataFlag = true;
                    continue;
                }
                if (one.startsWith("Content-Disposition:") && (filePnt = one.indexOf("; filename=\"")) != -1) {
                    fileName = FileUtil.getFileName(one.substring(filePnt += "; filename=\"".length(), one.indexOf("\"", filePnt))).trim();
                }
                if ((namePnt = one.indexOf("; name=\"")) != -1) {
                    keyName = one.substring(namePnt += "; name=\"".length(), one.indexOf("\"", namePnt)).trim();
                    continue;
                }
                if (one.startsWith("Content-Type:")) {
                    mimeType = one.substring("Content-Type:".length(), one.length()).trim();
                    continue;
                }
                throw new IllegalArgumentException("\u4e0d\u6b63\u306a\u6761\u4ef6\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            }
            if (fileName != null) {
                p = ConvertHttpParams.getIndexOf(binary, b, target);
                if (p == -1) {
                    throw new IllegalArgumentException("\u4e0d\u6b63\u306a\u6761\u4ef6\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                }
                int len = p - (b + enterLen);
                byte[] update = new byte[len];
                System.arraycopy(binary, b, update, 0, len);
                b = p;
                HttpBinaryImpl bin = new HttpBinaryImpl(fileName, mimeType, update);
                ConvertHttpParams.putRequestParams(out, keyName, bin);
            } else {
                p = ConvertHttpParams.getIndexOf(binary, b, target);
                if (p == -1) {
                    throw new IllegalArgumentException("\u4e0d\u6b63\u306a\u6761\u4ef6\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                }
                one = new String(binary, b, p - (b + enterLen), CHARSET);
                b = p;
                ConvertHttpParams.putRequestParams(out, keyName, one);
            }
            keyName = null;
            fileName = null;
            mimeType = null;
            dataFlag = false;
            keyFlag = false;
        }
    }

    private static final byte[] getInputStreamByBytes(InputStream stream) throws Exception {
        BufferedInputStream buf = null;
        ByteArrayOutputStream bo = null;
        byte[] ret = null;
        try {
            buf = new BufferedInputStream(stream);
            bo = new ByteArrayOutputStream();
            byte[] bin = new byte[8192];
            while (true) {
                int len;
                if ((len = stream.read(bin)) <= 0) {
                    if (len > -1) continue;
                    break;
                }
                bo.write(bin, 0, len);
            }
            buf.close();
            buf = null;
            ret = bo.toByteArray();
            bo.close();
            bo = null;
        }
        finally {
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (Exception exception) {}
                buf = null;
            }
            if (bo != null) {
                try {
                    bo.close();
                }
                catch (Exception exception) {}
                bo = null;
            }
        }
        return ret;
    }

    private static final void putRequestParams(HashMap<String, Object> map, String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof HttpBinary) {
            Object o = map.get(key);
            if (o == null) {
                map.put(key, value);
            } else if (o.getClass().getName().equals(ArrayList.class.getName())) {
                ArrayList lst = (ArrayList)o;
                lst.add(value);
            } else {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(o);
                lst.add(value);
                map.put(key, lst);
            }
        } else if (value instanceof String || value instanceof String[] && ((String[])value).length == 1) {
            Object o;
            if (value instanceof String[]) {
                value = ((String[])value)[0];
            }
            if ((o = map.get(key)) != null) {
                ArrayList<Object> lst = null;
                if (o.getClass().getName().equals(ArrayList.class.getName())) {
                    lst = (ArrayList<Object>)o;
                } else {
                    lst = new ArrayList<Object>();
                    lst.add(o);
                    map.put(key, lst);
                }
                lst.add(value);
            } else {
                map.put(key, value);
            }
        } else if (value instanceof String[]) {
            Object o = map.get(key);
            ArrayList<Object> lst = null;
            if (o != null) {
                if (o.getClass().getName().equals(ArrayList.class.getName())) {
                    lst = (ArrayList<Object>)o;
                } else {
                    lst = new ArrayList<Object>();
                    lst.add(o);
                    map.put(key, lst);
                }
            } else {
                lst = new ArrayList<Object>();
                map.put(key, lst);
            }
            String[] values = (String[])value;
            int len = values.length;
            int i = 0;
            while (i < len) {
                lst.add(values[i]);
                ++i;
            }
        }
    }

    private static int getIndexOf(byte[] binary, int pos, String data) throws Exception {
        if (data == null || data.length() <= 0) {
            return -1;
        }
        byte[] chk = data.getBytes(CHARSET);
        int chkLen = chk.length;
        int len = binary.length;
        int ret = -1;
        int i = pos;
        while (i < len) {
            if (binary[i] == chk[0] && i + chkLen < len) {
                ret = i;
                int j = 1;
                while (j < chkLen) {
                    if (binary[i + j] != chk[j]) {
                        ret = -1;
                        break;
                    }
                    ++j;
                }
                if (ret != -1) {
                    return ret;
                }
            }
            ++i;
        }
        return -1;
    }
}

