/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.dao.dbms.Record;
import org.maachang.engine.conf.Config;
import org.maachang.engine.servlet.ActionServlet;
import org.maachang.engine.servlet.DownloadFilter;
import org.maachang.engine.servlet.GlobalInfo;
import org.maachang.engine.servlet.HttpdTimestamp;
import org.maachang.engine.servlet.LocalInfo;
import org.maachang.engine.servlet.PageSession;
import org.maachang.engine.servlet.Parameter;
import org.maachang.engine.servlet.ResultMessage;
import org.maachang.engine.servlet.Validate;
import org.maachang.engine.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Action<T> {
    protected static final Log LOG = LogFactory.getLog(Action.class);
    private String errorPageName = null;
    private final Class defineForm;
    private final boolean validateFlag;

    public Action() {
        this.defineForm = null;
        this.validateFlag = false;
    }

    protected Action(boolean validateFlag) {
        this.defineForm = null;
        this.validateFlag = validateFlag;
    }

    protected Action(Class formClass) {
        this.defineForm = formClass != null ? formClass : null;
        this.validateFlag = false;
    }

    protected Action(boolean validateFlag, Class formClass) {
        this.defineForm = formClass != null ? formClass : null;
        this.validateFlag = validateFlag;
    }

    public abstract String execution(ResultMessage var1, T var2, Parameter var3) throws Exception;

    public String validate(Validate validate, ResultMessage result, T formObject, Parameter parameter) throws Exception {
        if (this.validateFlag) {
            throw new IllegalArgumentException("Validate\u51e6\u7406\u3092\u5b9f\u88c5\u3057\u3066\u3044\u307e\u305b\u3093");
        }
        return null;
    }

    protected void cacheOff() {
        HttpServletResponse res = LocalInfo.getResponse();
        res.setHeader("Expires", HttpdTimestamp.getTimestamp(0L));
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Last-Modified", HttpdTimestamp.getNowTimestamp());
        res.setHeader("Cache-Control", "private");
        res.addHeader("Cache-Control", "no-cache");
        res.addHeader("Cache-Control", "no-store");
        res.addHeader("Cache-Control", "max-age=0");
    }

    protected void redirect(String url) throws Exception {
        if (url == null || (url = url.trim()).length() <= 0) {
            return;
        }
        try {
            HttpServletRequest req = LocalInfo.getRequest();
            HttpServletResponse res = LocalInfo.getResponse();
            if (req == null || res == null) {
                return;
            }
            String ctx = req.getContextPath();
            if (url.startsWith("/") && !url.startsWith(String.valueOf(ctx) + "/")) {
                url = String.valueOf(ctx) + url;
            }
            res.sendRedirect(url);
        }
        finally {
            LocalInfo.clear();
        }
    }

    protected void forward(String url) throws Exception {
        if (url == null || (url = url.trim()).length() <= 0) {
            return;
        }
        try {
            HttpServletRequest req = LocalInfo.getRequest();
            HttpServletResponse res = LocalInfo.getResponse();
            if (req == null || res == null) {
                return;
            }
            String ctx = req.getContextPath();
            if (url.startsWith("/") && !url.startsWith(String.valueOf(ctx) + "/")) {
                url = String.valueOf(ctx) + url;
            }
            RequestDispatcher disp = req.getRequestDispatcher(url);
            disp.forward((ServletRequest)req, (ServletResponse)res);
        }
        finally {
            LocalInfo.clear();
        }
    }

    protected void forwardDownload(String fileName, byte[] binary) throws Exception {
        this.forwardDownload(fileName, null, new ByteArrayInputStream(binary));
    }

    protected void forwardDownload(String fileName, InputStream stream) throws Exception {
        this.forwardDownload(fileName, null, stream);
    }

    protected void forwardDownload(String fileName, String mimeType, byte[] binary) throws Exception {
        this.forwardDownload(fileName, mimeType, new ByteArrayInputStream(binary));
    }

    protected void forwardDownload(String fileName, String mimeType, InputStream stream) throws Exception {
        if (fileName == null || (fileName = fileName.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        }
        String key = DownloadFilter.setDownloadInfo(LocalInfo.getRequest(), mimeType, stream);
        this.redirect(String.valueOf(fileName) + "?" + "_downloadId" + "=" + key);
    }

    protected HttpServletRequest request() {
        return LocalInfo.getRequest();
    }

    protected HttpServletResponse response() {
        return LocalInfo.getResponse();
    }

    protected Record record() {
        return LocalInfo.getRecord();
    }

    protected int getSequenceId() {
        return ActionServlet.getRequestSequenceId(this.request());
    }

    protected PageSession pageSession() {
        return LocalInfo.getInnerSession();
    }

    protected Config getConfig() {
        return GlobalInfo.getConfig();
    }

    public String getRealPath(String path) throws Exception {
        return FileUtil.marge(GlobalInfo.getRealPath(), path);
    }

    public void setErrorPageName(String errorPageName) {
        if (this.errorPageName == null) {
            this.errorPageName = errorPageName;
        }
    }

    public String getErrorPageName() {
        return this.errorPageName;
    }

    public Object getFormObject() {
        Object ret = null;
        if (this.defineForm != null) {
            try {
                ret = this.defineForm.newInstance();
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    public boolean isValidate() {
        return this.validateFlag;
    }
}

