/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.ctbl;

import java.util.HashSet;
import org.maachang.dao.dbms.ctbl.Table;
import org.maachang.dao.dbms.ctbl.TableUtil;
import org.maachang.engine.conf.Config;
import org.maachang.engine.util.StringUtil;

public class TableMySql
implements Table {
    public String getAdapter() {
        return "mysql";
    }

    public String createTable(Config params) {
        StringBuilder buf = new StringBuilder();
        Object[] sections = params.getSections();
        if (sections != null && sections.length > 0) {
            int len = sections.length;
            int i = 0;
            while (i < len) {
                if (sections[i] != null) {
                    this.createOneSection(buf, (String)sections[i], params);
                }
                ++i;
            }
            return buf.toString();
        }
        return null;
    }

    public String typeByBoolean() {
        return "TINYINT(1)";
    }

    public String typeByInt() {
        return "INT";
    }

    public String typeByLong() {
        return "BIGINT";
    }

    public String typeByFloat() {
        return "FLOAT";
    }

    public String typeByDouble() {
        return "DOUBLE";
    }

    public String typeByBytes() {
        return "LONGBLOB";
    }

    public String typeByChar() {
        return "VARCHAR(255)";
    }

    public String typeByText() {
        return "TEXT";
    }

    public String typeByDate() {
        return "DATE";
    }

    public String typeByTime() {
        return "TIME";
    }

    public String typeByTimestamp() {
        return "DATETIME";
    }

    public String primaryKeyName() {
        return "PRIMARY KEY";
    }

    public String indexName() {
        return "INDEX";
    }

    public String notNullName() {
        return "NOT NULL";
    }

    public String uniqueName() {
        return "UNIQUE";
    }

    public String defaultName() {
        return "DEFAULT";
    }

    private void createOneSection(StringBuilder buf, String section, Config params) {
        if (section == null) {
            return;
        }
        String[] keys = params.getKeys(section);
        if (keys != null && keys.length > 0) {
            int len = keys.length;
            String tableType = null;
            HashSet<String> index = new HashSet<String>();
            HashSet<String> primaryKey = new HashSet<String>();
            buf.append("drop table ").append(section).append("; \n");
            buf.append("create table ").append(section).append("(");
            buf.append("id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT");
            boolean next = true;
            int i = 0;
            while (i < len) {
                if (next) {
                    buf.append(",");
                    next = false;
                }
                String key = keys[i];
                String type = null;
                String not_null = null;
                String unique = null;
                String def = null;
                String[] one = params.getAll(section, key);
                int lenJ = one.length;
                int[] mode = new int[1];
                if (!"id".equals(key.toLowerCase())) {
                    if (TableUtil.isType(key)) {
                        tableType = one[0];
                    } else {
                        int j = 0;
                        while (j < lenJ) {
                            String tmp = null;
                            tmp = TableUtil.getColumnName(this, one[j]);
                            if (tmp != null) {
                                type = tmp;
                            } else {
                                tmp = TableUtil.getColumnType(mode, this, one[j]);
                                if (tmp != null) {
                                    switch (mode[0]) {
                                        case 1: {
                                            not_null = tmp;
                                            break;
                                        }
                                        case 2: {
                                            unique = tmp;
                                            break;
                                        }
                                        case 3: {
                                            if (this.typeByBoolean().equals(type)) {
                                                String data = tmp.substring("default".length(), tmp.length()).trim();
                                                data = "true".equals(data = StringUtil.catCote(data).toLowerCase()) ? (String)this.getBooleanByTrue() : (String)this.getBooleanByFalse();
                                                def = String.valueOf(this.defaultName()) + " '" + data + "'";
                                                break;
                                            }
                                            if (this.typeByBytes().equals(type)) break;
                                            def = tmp;
                                        }
                                    }
                                } else {
                                    if (TableUtil.isIndex(one[j])) {
                                        index.add(key.toLowerCase());
                                        not_null = this.notNullName();
                                    }
                                    if (TableUtil.isKey(one[j])) {
                                        primaryKey.add(key.toLowerCase());
                                        not_null = this.notNullName();
                                    }
                                }
                            }
                            ++j;
                        }
                        if (type != null) {
                            buf.append(key.toLowerCase()).append(" ").append(type);
                            if (unique != null) {
                                buf.append(" ").append(unique);
                            }
                            if (not_null != null) {
                                buf.append(" ").append(not_null);
                            }
                            if (def != null) {
                                buf.append(" ").append(def);
                            }
                            next = true;
                        }
                    }
                }
                ++i;
            }
            if (!buf.toString().endsWith(",")) {
                buf.append(",");
            }
            if (primaryKey.size() > 0) {
                buf.append(this.primaryKeyName()).append("(");
                buf.append("id");
                Object[] vals = primaryKey.toArray();
                int lenI = vals.length;
                int i2 = 0;
                while (i2 < lenI) {
                    buf.append(",").append(vals[i2]);
                    ++i2;
                }
                buf.append(")");
            } else {
                buf.append(this.primaryKeyName()).append("(id)");
            }
            if (index.size() > 0) {
                buf.append(",");
                buf.append(this.indexName()).append("(");
                Object[] vals = index.toArray();
                int lenI = vals.length;
                int i3 = 0;
                while (i3 < lenI) {
                    if (i3 != 0) {
                        buf.append(",");
                    }
                    buf.append(vals[i3]);
                    ++i3;
                }
                buf.append(")");
            }
            buf.append(")");
            if (tableType != null) {
                buf.append("type=").append(tableType);
            }
            buf.append(" ; \n");
        }
    }

    public Object getBooleanType(Boolean src) {
        return src;
    }

    public Object getBooleanByTrue() {
        return "1";
    }

    public Object getBooleanByFalse() {
        return "0";
    }
}

